#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "utilvago.h"
#include "preferences.h"
#include "manualcommands.h"
#include "about.h"
#include "packagewizard.h"
#include "soundwizard.h"
#include "converter.h"
#include "droptablewidget.h"

#include <QMainWindow>
#include <QMessageBox>
#include <QProcess>
#include <QColor>
#include <QPalette>
#include <QFileDialog>
#include <QUrl>
#include <QDesktopServices>
#include <QErrorMessage>
#include <QTextCodec>
#include <QProgressBar>
#include <QComboBox>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QCloseEvent>
#include <QScriptEngine>
#include <QScriptValueIterator>
#include <QWinTaskbarProgress>
#include <QWinTaskbarButton>

#include "libs/pugixml/pugixml.hpp"
//#include <QDebug>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);

    ~MainWindow();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void on_actionExit_triggered();

    void on_actionAbout_triggered();

    void on_tbOni_clicked();

    void on_tbAE_clicked();

    void on_tbOpenFolder_clicked();

    void on_cbEnvMap_toggled(bool checked);

    void on_cbTexture_toggled(bool checked);

    void on_actionCheck_For_Updates_triggered();

    void on_pbAddSourceXML_clicked();

    void on_pbConvert_clicked();

    void TsetupProgressBar(int max);

    void TupdateProgressBar();

    void TresultConversion(QString result, int numErrors);

    void TconversionAborted();

    void on_actionWindows_triggered();

    void on_actionMac_Windows_demo_triggered();

    void on_pbClearSourcesXML_clicked();

    void on_pbRemoveSourceXML_clicked();

    void on_pbAddSourceTextures_clicked();

    void on_pbRemoveSourceTextures_clicked();

    void on_pbClearSourcesTextures_clicked();

    void on_cbFromTextures_currentIndexChanged(const QString &arg1);

    void on_cbFromObjects_currentIndexChanged(const QString &arg1);

    void on_cbFromLevels_currentIndexChanged(const QString &arg1);

    void on_cbFromMisc_currentIndexChanged(const QString &arg1);

    void on_pbAddSourceObjects_clicked();

    void on_pbAddSourceLevels_clicked();

    void on_pbAddSourceMisc_clicked();

    void on_pbRemoveSourceObjects_clicked();

    void on_pbRemoveSourceLevels_clicked();

    void on_pbRemoveSourceMisc_clicked();

    void on_pbClearSourcesObjects_clicked();

    void on_pbClearSourcesLevels_clicked();

    void on_pbClearSourcesMisc_clicked();

    void on_actionPreferences_triggered();

    void on_cbToLevels_currentIndexChanged(const QString &arg1);

    void on_cbDatLevels_toggled(bool checked);

    void on_actionCheck_OniSplit_version_triggered();

    void addFilesSource(DropTableWidget *myTable, QStringList files); //for drag 'n drop

    void dtContextMenu(DropTableWidget* myTable, QContextMenuEvent *event); //Context menu options for table widgets

    void checkVagoLastVersion(QNetworkReply *result); //check vago last version

    void on_cbBnvLevels_toggled(bool checked);

    void on_cbAdditionalSourcesLevels_toggled(bool checked);

    void on_tbCommand_clicked();

    void on_actionWorkspace_triggered();

    void on_actionOther_triggered();

    void on_actionView_log_triggered();

    void on_actionAE_Package_Creator_triggered();

    void on_cbFromCharacters_currentIndexChanged(const QString &arg1);

    void on_pbAddSourceCharacters_clicked();

    void on_pbRemoveSourceCharacters_clicked();

    void on_pbClearSourcesCharacters_clicked();

    void on_actionSound_Wizard_triggered();

    void on_actionCheck_xmlTools_version_triggered();

    void on_actionOpen_AE_folder_triggered();

    void on_cbWithTRBS_ONCC_toggled(bool checked);

    void on_cbWithAnimation_toggled(bool checked);

    void on_cbFromXML_currentIndexChanged(const QString &arg1);

    void on_cbSpecificFilesLevels_toggled(bool checked);

    void on_tbAbortConversion_clicked();

    void on_tabWidget_currentChanged(int);

    void on_actionSave_Project_triggered();

    void on_actionSave_triggered();

    void on_actionLoad_Project_triggered();

    void on_actionProject1_triggered();

    void on_actionProject2_triggered();

    void on_actionProject3_triggered();

    void on_actionProject4_triggered();

    void on_actionProject5_triggered();

private:
    Ui::MainWindow *ui;
    Logger *myLogger;
    QString workspaceLocation; //Workspace location
    QString workspaceWizardsLocation; //Workspace wizard location
    QString outputFolder; //Output folder
    QString AeLocation; //Workspace location
    QString lastProjectFilePath;
    int startedWindowWidth;
    int startedWindowHeight;
#ifdef Q_OS_MAC
    bool useYesAsDefaultWhenRemovingItems;
#endif
    QLabel *itemsLoaded;
    QProgressBar *myBar; //Progress Bar
    QHash<QString, QString> commandMap; //Map the commands for fast retreive
    QStringList *listToProccess; //items to proccess
    Converter *myConverter;
    QSettings *vagoSettings;
    static const QString VagoSettingsName;
    static constexpr int recentProjectsMaxSize=5;
    QList<QString> recentProjectsList;
#ifdef Q_OS_WIN
    // These are deleted automatically by the window (since button is attached to it)
    QWinTaskbarProgress *win7TaskBarProgress;
    QWinTaskbarButton *win7TaskBarButton;
#endif

    // anonymous enum
    enum {XMLTabIndex, TexturesTabIndex, CharactersTabIndex, ObjectsTabIndex, LevelsTabIndex, MiscTabIndex};

    void connectSlots();
    void showErrStatusMessage(QString message);
    void showSuccessStatusMessage(QString message);
    void mapCommands();
    void addRowTable(DropTableWidget *myTable, QString file, QString fromTo, QString command, bool isToDisabled=false);
    void clearTableContents(DropTableWidget *myTable);
    void clearTableNoPrompt(DropTableWidget *myTable);
    void removeTableContents(DropTableWidget *myTable);
    void updateComboBox(const QString &arg1, QComboBox *comboBox);
    void startConversion();
    void updateItemsLoaded(DropTableWidget *currentTable);
    void changeToCurrentSettings(QList<int> rows, DropTableWidget* myTable); //change some rows to the current settings
    void changeItemsOutput(DropTableWidget* myTable, QList<int> rows, QString newOutput);
    void setConverterButtonsSize();
    void saveProjectState(const QString &filePath);
    void saveProjectWidget(pugi::xml_node &rootNode, DropTableWidget* table);
    void loadProjectState(const QString &filePath);
    void setVagoWindowTitle();
    void loadProjectWidget(pugi::xml_document &doc, DropTableWidget* table);
    void saveRecentProjects();
    void loadRecentProjects();
    void addNewRecentProject(const QString &filePath);
    void reloadRecentProjectsMenu();
    void showEvent(QShowEvent *e);
    QString getFileOutputFolder(QString fromTo, QString myOutputFolder="");
    QString fileParsingXML(QString tabTitle, QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingTextures(QString tabTitle, QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingObjects(QString tabTitle, QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingCharacters(QString tabTitle, QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingLevels(QString tabTitle, QString myOutputFolder, QString from, QString to , QString file);
    QString fileParsingMisc(QString myOutputFolder, QString from, QString to , QString file);
    QString getCommand(DropTableWidget* myTable, QString myOutputFolder, QString from, QString to , QString file);
    QString getTypeConversion(DropTableWidget *myTable); //get the current type for a table
    QString getOSIndependentAppPath();
    QString getTabNameByTableWidget(DropTableWidget* table);
    QString getCurrentTabName();
    QRadioButton* getTextureRBCheckedTypeTexture();
    QRadioButton *getTextureRBTypeTextureByName(const QString &texType);
    DropTableWidget *getCurrentTableWidget();
    DropTableWidget* getTableWidgetByTabName(const QString &tabName);
    QList<DropTableWidget*> getAllTableWidgets();

signals:
    void terminateCurrProcess();
};

#endif // MAINWINDOW_H
