#include "soundpagefinal.h"
#include "ui_soundpagefinal.h"

SoundPageFinal::SoundPageFinal(QString AppDir, QString soundsLocation, DropTableWidget *page2Table, Logger *myLogger, QHash<QString, QString> *commandMap, QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::soundpagefinal)
{
    ui->setupUi(this);
    this->soundsLocation=soundsLocation;
    this->page2Table=page2Table;
    this->myLogger=myLogger;
    this->commandMap=commandMap;

    this->xmlCommands = new QStringList();
    this->oniSplitCommands = new QStringList();
    this->myXmlProcessor = new XmlProcessor(AppDir, this->myLogger,this->xmlCommands);
    this->myConverter = new Converter(AppDir, this->myLogger,this->oniSplitCommands);

    ui->lbComplete->setText("<html>The wizard is now complete. The sounds have been converted. "
                            "You can view all converted files clicking <a href=' '>here.</a><br />"
                            "<br />Click restart to create more sounds from the wizard beggining, "
                            "otherwise click finish.</html>"); // Don't use rich text in qtdesigner because it generates platform dependent code

    connectSlots();
}

void SoundPageFinal::openSoundsFolder(){
    QString outputFolder;

    if(field("rbOther").toBool()){
        outputFolder=field("leOtherLocation").toString();
    }
    else{
        outputFolder=this->soundsLocation;
    }

    QDesktopServices::openUrl(QUrl("file:///"+outputFolder));
}

void SoundPageFinal::initializePage(){
    startProcessing();
}

void SoundPageFinal::startProcessing(){
    // Sample files names
    QString ambFile="OSBDsample_file.amb.xml";
    QString grpFile="OSBDsample_file.grp.xml";
    QString ambFileLocation=GlobalVars::VagoTemporaryDir+"/"+ambFile;
    QString grpFileLocation=GlobalVars::VagoTemporaryDir+"/"+grpFile;

    // Page 2 variables
    QString outputFolder;

    // Page 3 variables
    QString sphereRadious, minElapsedTime, maxElapsedTime, minVolumeDistance,
            maxVolumeDistance, minOcclusion, treshold, priority;
    QStringList flags;
    bool priorityLow = false, priorityNormal = false,
            priorityHigh = false, priorityHighest = false;

    bool interruptOnStop=false;
    bool playOnce=false;
    bool canPan=false;

    // Page 4 variables
    QString volume, minVolume, maxVolume, pitch, minPitch, weight, maxPitch,
            numberChannels;
    bool preventRepeat=false;
    bool stereo22=false, mono22=false, mono44Pc=false;

    // Get data page 2
    if(field("rbOther").toBool()){
        outputFolder=field("leOtherLocation").toString();
    }
    else{
        outputFolder=this->soundsLocation;
    }

    outputFolder = Util::insertQuotes(outputFolder); // for onisplit work correctly

    // Get data page 3

    priorityLow=field("rbPriorityLow").toBool();
    priorityNormal=field("rbPriorityNormal").toBool();
    priorityHigh=field("rbPriorityHigh").toBool();
    priorityHighest=field("rbPriorityHighest").toBool();

    if(priorityNormal){
        priority="Normal";
    }
    else if(priorityLow){
        priority="Low";
    }
    else if(priorityHigh){
        priority="High";
    }
    else if(priorityHighest){
        priority="Highest";
    }

    if(interruptOnStop){
        flags << "InterruptTracksOnStop";
    }

    if(playOnce){
        flags << "PlayOnce";
    }

    if(canPan){
        flags << "CanPan";
    }

    interruptOnStop=field("cbInterruptOnStop").toBool();
    playOnce=field("cbPlayOnce").toBool();
    canPan=field("cbCanPan").toBool();

    sphereRadious=Util::normalizeDecimalSeparator(field("leSphereRadious").toString());
    minElapsedTime=Util::normalizeDecimalSeparator(field("leMinElapsedTime").toString());
    maxElapsedTime=Util::normalizeDecimalSeparator(field("leMaxElapsedTime").toString());
    minVolumeDistance=Util::normalizeDecimalSeparator(field("leMinVolumeDistance").toString());
    maxVolumeDistance=Util::normalizeDecimalSeparator(field("leMaxVolumeDistance").toString());
    minOcclusion=Util::normalizeDecimalSeparator(field("leMinOcclusion").toString());
    treshold=Util::normalizeDecimalSeparator(field("leTreshold").toString());

    // Get data page 4

    volume=Util::normalizeDecimalSeparator(field("leVolume").toString());
    minVolume=Util::normalizeDecimalSeparator(field("leMinVolume").toString());
    maxVolume=Util::normalizeDecimalSeparator(field("leMaxVolume").toString());
    pitch=Util::normalizeDecimalSeparator(field("lePitch").toString());
    minPitch=Util::normalizeDecimalSeparator(field("leMinPitch").toString());
    maxPitch=Util::normalizeDecimalSeparator(field("leMaxPitch").toString());
    weight=Util::normalizeDecimalSeparator(field("leWeight").toString());

    preventRepeat=field("cbPreventRepeat").toBool();

    stereo22=field("rbStereo22").toBool();
    mono22=field("rbMono22").toBool();
    mono44Pc=field("rbMono44Pc").toBool();

    if(stereo22 || mono44Pc){
        numberChannels="2";
    }
    else if(mono22){
        numberChannels="1";
    }
    //######################################################### Starting xml processing

    // Clean tmp dir
    if(!Util::rmDir(GlobalVars::VagoTemporaryDir)){        
        UtilVago::showAndLogErrorPopUpLogButton(this->myLogger, "Couldn't clean vago temp dir for complete sound wizard. Aborting.\n"+GlobalVars::VagoTemporaryDir);
        return;
    }

    if(!QDir(QDir::tempPath()).mkpath("VagoTemp")){
        UtilVago::showAndLogErrorPopUpLogButton(this->myLogger, "Couldn't reconstruct vago temp dir for complete sound wizard. Aborting.\n"+GlobalVars::VagoTemporaryDir);
    }

    // Copy sample xml files to tmp dir
    QFile::copy(":/new/sampleFiles/"+ambFile , ambFileLocation);
    QFile::copy(":/new/sampleFiles/"+grpFile , grpFileLocation);
    QFile::setPermissions(ambFileLocation, QFile::ReadOwner | QFile::WriteOwner); //remove read only attribute that come from resources
    QFile::setPermissions(grpFileLocation, QFile::ReadOwner | QFile::WriteOwner);

    (*this->xmlCommands)
     << "--replace-all-values -e Priority -n "+Util::insertQuotes(priority)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values -e Flags -n "+(flags.join(" ").isEmpty() ? "\" \"" : Util::insertQuotes(flags.join(" ")))+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values -e SphereRadius -n "+Util::insertQuotes(sphereRadious)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values -e Treshold -n "+Util::insertQuotes(treshold)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values -e MinOcclusion -n "+Util::insertQuotes(minOcclusion)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name ElapsedTime -e  Min -n "+Util::insertQuotes(minElapsedTime)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name Distance -e  Max -n "+Util::insertQuotes(maxVolumeDistance)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name Distance -e  Min -n "+Util::insertQuotes(minVolumeDistance)+" -f "+Util::insertQuotes(ambFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name SoundGroup -e  Volume -n "+Util::insertQuotes(volume)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name SoundGroup -e  Pitch -n "+Util::insertQuotes(pitch)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name SoundGroup -e  NumberOfChannels -n "+Util::insertQuotes(numberChannels)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name Volume -e  Min -n "+Util::insertQuotes(minVolume)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name Volume -e  Max -n "+Util::insertQuotes(maxVolume)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name Pitch -e  Min -n "+Util::insertQuotes(minPitch)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values --parent-element-name Pitch -e  Max -n "+Util::insertQuotes(maxPitch)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose"
     << "--replace-all-values -e  Weight -n "+Util::insertQuotes(weight)+" -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose";

    if(preventRepeat){
        (*this->xmlCommands) << "--replace-all-values --parent-element-name SoundGroup -e Flags -n PreventRepeat -f "+Util::insertQuotes(grpFileLocation)+" --no-backups --no-verbose";
    }

    myXmlProcessor->start();
    myXmlProcessor->wait(); // Wait until all xml is edited

    QString currFileName;
    QString currGrpFileLocation;
    QString currAmbFileLocation;

    for(int i=0; i<this->page2Table->rowCount(); i++){

        (*this->oniSplitCommands) << this->commandMap->value("xml->XML->ONI")+" "+outputFolder+" "+Util::insertQuotes(this->page2Table->item(i,1)->text()); // add location of sound file to convert

        currFileName=this->page2Table->item(i,0)->text(); // get current file name
        currAmbFileLocation = QString(ambFileLocation).replace("sample_file",currFileName); // get the new files, filenames
        currGrpFileLocation = QString(grpFileLocation).replace("sample_file",currFileName);

        QFile::copy(ambFileLocation, currAmbFileLocation); // make a copy of the sample files that will be the real files
        QFile::copy(grpFileLocation, currGrpFileLocation);

        (*this->xmlCommands) << "--replace-all-values -e BaseTrack1 -n "+Util::insertQuotes(currFileName)+" -f "+Util::insertQuotes(currAmbFileLocation)+" --no-backups --no-verbose" // process the xml
                             << "--replace-all-values -e Sound -n "+Util::insertQuotes(currFileName)+" -f "+Util::insertQuotes(currGrpFileLocation)+" --no-backups --no-verbose";

        myXmlProcessor->start();
        myXmlProcessor->wait(); // Wait until all xml is edited
    }

    (*this->oniSplitCommands) << this->commandMap->value("xml->XML->ONI")+" "+outputFolder+" "+Util::insertQuotes(GlobalVars::VagoTemporaryDir+"/*.xml");

    this->myConverter->start(); // finally process the onisplit commands
    this->myConverter->wait(); // wait for it to complete

    // Finally remove the sample files, since not needed anymore
    QFile(ambFileLocation).remove();
    QFile(grpFileLocation).remove();
}

void SoundPageFinal::catchXmlAndOSplitProcessingError(QString result, int numErrors){

    if(numErrors!=0){
        QString sNumErrors=QString::number(numErrors);
        if(numErrors>1){
            UtilVago::showErrorPopUpLogButton(result+"\n This is the last of " + sNumErrors + " Errors.");
        }
        else{
            UtilVago::showErrorPopUpLogButton(result);
        }
    }
}

void SoundPageFinal::connectSlots(){
    //This signal is for thread that is working setup the progress bar (make it visible and set it's min-max)
    connect(this->myXmlProcessor, SIGNAL(resultConversion(QString, int)), this, SLOT(catchXmlAndOSplitProcessingError(QString, int)));
    connect(this->myConverter, SIGNAL(resultConversion(QString, int)), this, SLOT(catchXmlAndOSplitProcessingError(QString, int)));
    connect(ui->lbComplete, SIGNAL(linkActivated(const QString & )), this, SLOT(openSoundsFolder()));
}

SoundPageFinal::~SoundPageFinal()
{
    delete this->xmlCommands;
    delete this->oniSplitCommands;
    delete this->myXmlProcessor;
    delete this->myConverter;
    delete ui;
}
