#include "bgimagepage2.h"
#include "ui_bgimagepage2.h"

BGImagePage2::BGImagePage2(Logger *myLogger, QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::BGImagePage2)
{
    ui->setupUi(this);
    this->myLogger = myLogger;

    this->setTitle("Image to use as background");
    this->setSubTitle("Add here the image that you want to convert. Image width and height must be greater than or equal 256 pixels. Example of valid image resolutions: 640x480, 1024x768.");

    //Register fields
    registerField("leImageFullPath", ui->leImageFullPath);
    registerField("lbImageType", ui->lbImageType, "text");
}

void BGImagePage2::initializePage()
{
    // To the first time the page is displayed and when the wizard is restarted
    if(ui->leImageFullPath->text().isEmpty()){
        // enable / hide image fields until we have an image
        ui->gbImageInformation->setEnabled(false);
        ui->lbImagePreview->hide();
        ui->lbImageName->hide();
        ui->lbImageWidth->hide();
        ui->lbImageHeight->hide();
        ui->lbImageSize->hide();
        ui->lbDateCreated->hide();
        ui->lbDateModified->hide();
        ui->lbImageType->hide();
    }
}

bool BGImagePage2::validatePage(){
    QString leImageFullPath=ui->leImageFullPath->text().trimmed();

    if(!validateField(leImageFullPath)){
        return false;
    }

    return true;
}

bool BGImagePage2::validateField(QString &field){
    if(field.isEmpty()){
        Util::showErrorPopUp("You need to choose an image.");
        return false;
    }

    return true;
}

BGImagePage2::~BGImagePage2()
{
    delete ui;
}

void BGImagePage2::on_pbBrowse_clicked()
{
    QString selectedImage = QFileDialog::getOpenFileName(this,"Choose the image file...","./" , "Image (*.JPG *.JPEG *.PNG)");

    if(!selectedImage.isEmpty()){

        QImage myImage;
        if(!myImage.load(selectedImage)){
            UtilVago::showAndLogErrorPopUp(this->myLogger,"Couldn't load image '" + Util::cutNameWithoutBackSlash(selectedImage) + "'. Is the image corrupt?");
            return;
        }

        if(myImage.width() < 256 || myImage.height() < 256){
            UtilVago::showAndLogErrorPopUp(this->myLogger,"Image '" + Util::cutNameWithoutBackSlash(selectedImage) +
                                           "' does not have a width and height >= 256.");
            return;
        }

        ui->leImageFullPath->setText(selectedImage);
        ui->leImageFullPath->setToolTip(selectedImage);
        setImage(selectedImage, myImage);
    }
}

void BGImagePage2::setImage(const QString &imagePath, const QImage &image){

    QFileInfo myImageFileInfo(imagePath);

    ui->gbImageInformation->setEnabled(true);
    ui->lbImagePreview->show();
    ui->lbImageName->show();
    ui->lbImageWidth->show();
    ui->lbImageHeight->show();
    ui->lbImageSize->show();
    ui->lbDateCreated->show();
    ui->lbDateModified->show();
    ui->lbImageType->show();

    QPixmap previewImage(imagePath);
    ui->lbImagePreview->setPixmap( previewImage );
    ui->lbImagePreview->setMask(previewImage.mask());

    // Thanks bukkfa!
    // http://stackoverflow.com/questions/5653114/display-image-in-qt-to-fit-label-size
    ui->lbImagePreview->setScaledContents( true );
    ui->lbImagePreview->setSizePolicy( QSizePolicy::Ignored, QSizePolicy::Ignored );

    // Update image information
    ui->lbImageName->setText(myImageFileInfo.baseName().replace("." + myImageFileInfo.suffix(), ""));
    ui->lbImageWidth->setText(QString::number(image.width()));
    ui->lbImageHeight->setText(QString::number(image.height()));
    ui->lbImageType->setText(myImageFileInfo.suffix());
    ui->lbImageSize->setText(QString::number(myImageFileInfo.size()/1024.0));
    ui->lbDateCreated->setText(myImageFileInfo.created().toString());
    ui->lbDateModified->setText(myImageFileInfo.lastModified().toString());

    ui->lbImagePreview->show();
}
