#include "util.h"

namespace Util{

QString normalizePath(QString path){
    return path.replace("\\","/");
}

QString cutName(QString path){
    return path.remove(0,path.lastIndexOf('/')).remove('"');
}

QString cutNameWithoutBackSlash(QString path){
    return cutName(path).remove('/');
}

QString insertQuotes(const QString &currString){
    return "\""+currString+"\"";
}

QString normalizeAndQuote(QString path){
    return insertQuotes(normalizePath(path));
}

void showPopUp(const QString &message){
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
}

void showRichPopUp(const QString &message){
    QMessageBox msgBox;
    msgBox.setTextFormat(Qt::RichText);
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
}

void showWarningPopUp(const QString &message){
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Warning);
    msgBox.setText(message);
    msgBox.exec();
}

void showErrorPopUp(const QString &message){
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
}

void showRichErrorPopUp(const QString &message){
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
}

bool showQuestionPopUp(QWidget * parent, QString message, QMessageBox::StandardButton standardButton){
    return QMessageBox::question (parent, "Are you sure?", message, QMessageBox::Yes | QMessageBox::No, standardButton)==QMessageBox::Yes;
}

QMessageBox::StandardButton showQuestionPopUpWithCancel(QWidget * parent, QString message, QMessageBox::StandardButton standardButton){
    return QMessageBox::question (parent, "Are you sure?", message, QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel, standardButton);
}

QStringList multipleDirDialog(QString title){
    QFileDialog w;

    w.setFileMode(QFileDialog::DirectoryOnly);

    w.setWindowTitle(title);

    QListView *l = w.findChild<QListView*>("listView");

    if (l) {
        l->setSelectionMode(QAbstractItemView::MultiSelection);
    }

    QTreeView *t = w.findChild<QTreeView*>();

    if (t) {
        t->setSelectionMode(QAbstractItemView::MultiSelection);
    }

    if(w.exec()){ //if accepted
        return w.selectedFiles();
    }
    return QStringList(); //return empty
}

bool checkEmptySpaces(QStringList toCheck){
    foreach (QString current, toCheck){
        if(current.trimmed().isEmpty()){
            return true; //There are empty spaces
        }
    }
    return false;
}

bool checkIfIntegers(QStringList toCheck){
    foreach (QString current, toCheck){
        if(!isStringInteger(current)){
            return true; // Some aren't valid integers
        }
    }
    return false;
}

bool checkIfDoubles(QStringList toCheck){
    foreach (QString current, toCheck){
        if(!isStringDouble(current)){
            return true; // Some aren't valid doubles
        }
    }
    return false;
}

bool isStringInteger(QString myString){
    bool isNumber;

    myString.toInt(&isNumber); //convert to int and see if it succeeds

    return isNumber;
}

bool isStringDouble(QString myString){
    bool isDouble;

    myString.toDouble(&isDouble); //convert to double and see if it succeeds

    return isDouble;
}

// Created from scratch
bool copyDir(const QString &fromPath, QString toPath, const bool isRecursive){
    QDir fromDir(fromPath);
    QDir toDir(toPath);

    if(!toDir.mkdir(fromDir.dirName())){ // create the folder in the destination
        return false;
    }

    // Update toPath to include the folder from "fromPath"
    toPath = toPath + "/" + fromDir.dirName();
    toDir = QDir(toPath);

    for(const QFileInfo &currFileInfo : fromDir.entryInfoList(QDir::Dirs | QDir::Files | QDir::NoDotAndDotDot)){

        if(currFileInfo.isFile()){

            QFile destFile(toPath + "/" + currFileInfo.fileName());

            if(!QFile::copy(currFileInfo.absoluteFilePath(),toPath + "/" + currFileInfo.fileName())){
                return false;
            }
        }
        else if(isRecursive && currFileInfo.isDir() && currFileInfo.absoluteFilePath() != fromDir.absolutePath()){

            if(!copyDir(currFileInfo.absoluteFilePath(), toPath, isRecursive)){
                return false;
            }
        }
    }

    return true;
}

//Copied from here: http://stackoverflow.com/questions/2536524/copy-directory-using-qt (ty roop)
bool rmDir(const QString &dirPath)
{
    QDir dir(dirPath);
    if (!dir.exists())
        return true;
    foreach(const QFileInfo &info, dir.entryInfoList(QDir::Dirs | QDir::Files | QDir::NoDotAndDotDot)) {
        if (info.isDir()) {
            if (!rmDir(info.filePath()))
                return false;
        } else {
            if (!dir.remove(info.fileName()))
                return false;
        }
    }
    QDir parentDir(QFileInfo(dirPath).path());
    return parentDir.rmdir(QFileInfo(dirPath).fileName());
}


QString fullTrim(QString str) {

    str = str.simplified(); //convert all invisible chars in normal whitespaces
    str.replace( " ", "" );

    return str;
}

//Searches for the QString "toSearch" in the "myString" variable backward
//Returns the index of the first match or -1 if not found
int indexOfBackward(QString myString, QString toSearch, int from){
    int myStringSize=myString.size();
    int toSearchSize=toSearch.size();

    if(from==-1){
        from=myStringSize;
    }

    int i=from;

    while(i>=0){
        for(int j=toSearchSize-1; j>=0; j--){
            i--;
            if(myString.at(i)!=toSearch.at(j)){
                break;
            }
            if(j==0){
                return i;
            }
        }
    }

    return -1;
}

QStringList substring(QString myString,QString separator, Qt::CaseSensitivity cs){
    QStringList result = QStringList();
    int currIdx=0, nextIdx=0;

    while(true){
        nextIdx=myString.indexOf(separator,currIdx,cs);
        result << myString.mid(currIdx,nextIdx-currIdx);
        if(nextIdx==-1) break;
        currIdx=nextIdx+1;
    }

    return result;
}

QString normalizeDecimalSeparator(QString value){
    return value.replace(',','.');
}

// From here: http://stackoverflow.com/questions/17893328/qt-getting-the-screen-resolution-without-the-extended-monitor ty Chris
QRect getScreenResolution(){
    QDesktopWidget widget;
    return widget.availableGeometry(widget.primaryScreen()); // or screenGeometry(), depending on your needs
}

}
