#include "bgimagepage3.h"
#include "ui_bgimagepage3.h"

BGImagePage3::BGImagePage3(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::BGImagePage3)
{
    ui->setupUi(this);

    //Register fields
    registerField("cbCreateTXMB", ui->cbCreateTXMB);
    registerField("cbCreateTXMP", ui->cbCreateTXMP);
    registerField("leLevelId", ui->leLevelId);
    registerField("leImageName", ui->leImageName);
    registerField("leTXMBName", ui->leTXMBName);
}

BGImagePage3::~BGImagePage3()
{
    delete ui;
}

void BGImagePage3::initializePage()
{
    // To the first time the page is displayed and when the wizard is restarted
    generateImageName();
}

void BGImagePage3::on_cbCreateTXMP_toggled(bool checked)
{
    if(!checked){
        ui->cbCreateTXMB->setDisabled(true);
        ui->cbCreateTXMB->setChecked(false);
    }
    else{
        ui->cbCreateTXMB->setDisabled(false);
    }

}

void BGImagePage3::on_cbCreateTXMB_toggled(bool checked)
{
    if(!checked){
        ui->leTXMBName->setDisabled(true);
        ui->leTXMBName->clear();
    }
    else{
        ui->leTXMBName->setDisabled(false);
    }
}

void BGImagePage3::on_leLevelId_textChanged(const QString &arg1)
{
    if(!arg1.isEmpty() && !Util::isStringInteger(arg1)){
        Util::showErrorPopUp("Level id must be a number.");
        ui->leLevelId->clear();
        return;
    }

    if(!arg1.trimmed().isEmpty()){
        generateImageName();
    }
}

void BGImagePage3::on_cbTargetForImage_currentIndexChanged(const QString)
{
    generateImageName();
}

void BGImagePage3::generateImageName(){

    QString type = ui->cbTargetForImage->currentText();
    QString backgroundName;
    QString txmbName;
    QString levelNumber = "00";

    if(ui->leLevelId->text().length() == 1){
        levelNumber = ("0" + ui->leLevelId->text());
    }
    else if(ui->leLevelId->text().length() > 1){
        levelNumber = ui->leLevelId->text();
    }

    if(type == "Other"){
        backgroundName = "TXMPother";
        txmbName = "TXMBother";
    }
    else if(type == "Intro Screen"){
        backgroundName = "TXMPlevel" + levelNumber + "_intro_";
        txmbName = "TXMBintro_splash_screen";
    }
    else if(type == "Win Screen"){
        backgroundName = "TXMPlevel" + levelNumber + "_win_";
        txmbName = "TXMBwin_splash_screen";
    }
    else if(type == "Loose Screen"){
        backgroundName = "TXMPfail01_";
        txmbName = "TXMBfail_splash_screen";
    }
    else if(type == "Main Menu Screen"){
        backgroundName = "TXMPOni_startup_";
        txmbName = "TXMBpict_mainmenu";
    }
    else if(type == "Options Menu Screen"){
        backgroundName = "TXMPoptions_";
        txmbName = "TXMBpict_options_background";
    }
    else if(type == "Load Level Screen"){
        backgroundName = "TXMPoni_kanji_";
        txmbName = "TXMBpict_loadgame_background";
    }

    ui->leImageName->setText(backgroundName);

    if(ui->cbCreateTXMB->isChecked()){
        ui->leTXMBName->setText(txmbName);
    }
}


bool BGImagePage3::validatePage(){

    QStringList namesList;

    if(ui->leImageName->text().trimmed().isEmpty()){
        Util::showErrorPopUp("You need to input a name to the image!");
        return false;
    }

    if(ui->cbCreateTXMB->isChecked() && ui->leTXMBName->text().trimmed().isEmpty()){
        Util::showErrorPopUp("You need to input a name to the TXMB file!");
        return false;
    }

    return true;
}

