#ifndef XMLTOOLSINTERFACE_H
#define XMLTOOLSINTERFACE_H

#include <QMainWindow>
#include <QClipboard>
#include <QProcess>
#include <QScrollBar>
#include <QDragEnterEvent>
#include <QMimeData>
#include <QHBoxLayout>

#include "utilvago.h"
#include "xmlprocessor.h"
#include "xmltoolsinterfacecommandpreview.h"


namespace Ui {
class XmlToolsInterface;
}

class XmlToolsInterface : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit XmlToolsInterface(Logger *myLogger, QWidget *parent = 0);
    ~XmlToolsInterface();

protected:
    
private slots:

    void TXmlToolsResult(QString result, int numErrors);

    void on_rbFilterRelativeElements_clicked();

    void on_rbFilterXPathExpression_clicked();

    void on_cbXmlToolsOperation_currentIndexChanged(const QString &arg1);

    void on_cbFilterParentElement_toggled(bool checked);

    void on_cbFilterAttributeName_toggled(bool checked);

    void on_pbInputBrowse_clicked();

    void on_pbPreviewOperation_clicked();

    void on_pbOperationCommandCopyToClipboard_clicked();

    void on_leInputInputFiles_textChanged(const QString &arg1);

    void on_leFilterElement_textChanged(const QString &arg1);

    void on_leFilterParentElement_textChanged(const QString &arg1);

    void on_leFilterAttributeName_textChanged(const QString &arg1);

    void on_leFilterAttributeValue_textChanged(const QString &arg1);

    void on_leInputCurrentValues_textChanged(const QString &arg1);

    void on_leInputNewValues_textChanged(const QString &arg1);

    void on_leInputPositions_textChanged(const QString &arg1);

    void on_leInputDiffOldNewValue_textChanged(const QString &arg1);

    void on_cbOptionsNoBackups_toggled(bool checked);

    void on_pbApplyOperation_clicked();

private:
    Ui::XmlToolsInterface *ui;
    Logger *myLogger = nullptr;
    QStringList listToProccess; //commands to execute
    XmlProcessor *xmlProcessor = nullptr;
    bool previewInProgress = false;

    bool validateInput();
    QString buildCommand(const QString &alternativeFileLocation = "");
    void setCommand();
    void dropEvent(QDropEvent* event);
    void dragEnterEvent(QDragEnterEvent *event);
};

#endif // XMLTOOLSINTERFACE_H
