#ifndef BGIMAGEPAGEFINAL_H
#define BGIMAGEPAGEFINAL_H

#include <QWizardPage>
#include <QImage>
#include <pugixml.hpp>

#include "utilvago.h"
#include "converter.h"

namespace Ui {
class BGImagePageFinal;
}

class BGImagePageFinal : public QWizardPage
{
    Q_OBJECT

public:
    explicit BGImagePageFinal(QString appDir, Logger *myLogger, QString bgImagesLocation, QWidget *parent = 0);
    ~BGImagePageFinal();

private:
    Ui::BGImagePageFinal *ui;
    QString appDir;
    QString bgImagesLocation;
    Logger *myLogger;
    Converter *myOniSplitConverter;
    QStringList *oniSplitCommands;

    void initializePage();
    void startProcessing();

    QVector<int> getSplitSizes(int imageSideSize);
    QList<QString> splitIntoMultipleImages(QImage sourceImage, QString imageName, QString imageType);
    QString createTxmbXmlFile(QList<QString> imagesSplitted, QString fileName, const QSize &imageSize, QString levelId);
    void connectSlots();

private slots:
    void openBGImagesFolder();
    void catchOniSplitProcessingErrors(QString result, int numErrors);
};

#endif // BGIMAGEPAGEFINAL_H
