#ifndef WMPAGE_H
#define WMPAGE_H

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QTextEdit>
#include <QGroupBox>
#include <QLabel>
#include <QSpacerItem>
#include <QToolButton>
#include <QFileDialog>
#include <functional>

#include "utilvago.h"

class WmPage : public QObject // for signals and slots
{
    Q_OBJECT
public:
    WmPage(QWidget *currentTab);
    QTextEdit& getMainText();
    QTextEdit& getFooterText();
    QLabel& getMiddleImage();
    void hideFooterText();
    void showFooterText();
private:
    QTextEdit* mainText;
    QTextEdit* footerText;
    QLabel* middleImage;
    QToolButton* addRemoveImageButton;
    QWidget *pageTab;
    QGroupBox *footerTextGroupBox;
private:
    void createAndAddPageToTab(QWidget *currentTab);
private slots:
    void addRemoveImageButtonTriggered();
};

#endif // WMPAGE_H
