#include "bgimagewizard.h"

BGImageWizard::BGImageWizard(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger)
:AbstractWizard(appDir, workspaceWizardLocation, vagoSettings, myLogger, true)
{
    this->appDir = appDir;
    this->workspaceWizardLocation=workspaceWizardLocation;
    this->vagoSettings=vagoSettings;
    this->myLogger=myLogger;
    this->bgImagesLocation=this->workspaceWizardLocation+"/BGImages";
}

void BGImageWizard::exec(){

    BGImagePage2 *page2 = new BGImagePage2(this->myLogger);
    BGImagePage3 *page3 = new BGImagePage3();
    BGImagePageFinal *pageFinal = new BGImagePageFinal(this->appDir, this->myLogger, this->bgImagesLocation);

    this->myWizard.addPage
    (
        createIntroPage
        (
            "Welcome to the Oni Background Image Wizard.\n"
            "This wizard will allow you to create in a few and simple steps Oni background images (TXMB) "
            "that can be used in the menus or as backgrounds screens for the levels."
        )
    );

    this->myWizard.addPage(page2);
    this->myWizard.addPage(page3);
    this->myWizard.addPage(pageFinal);

    showWizard("Background Image Wizard", ":/new/icons/background_image.png");
}

void BGImageWizard::beforeClose(QDialog::DialogCode){

}
