#ifndef WMFINALPAGE_H
#define WMFINALPAGE_H

#include <QWizardPage>
#include <QDesktopServices>
#include <QUrl>
#include <droptablewidget.h>
#include <pugixml.hpp>

#include "logger.h"
#include "xmlprocessor.h"
#include "converter.h"
#include "wmpage.h"
#include "wmsetuppage.h"

namespace Ui {
class wmfinalpage;
}

class WmFinalPage : public QWizardPage
{
    Q_OBJECT
    
public:
    explicit WmFinalPage(QString AppDir, QString wmLocation, Logger *myLogger, QList<std::shared_ptr<WmPage> > &pages, QWidget *parent = 0);
    ~WmFinalPage();
    
private:
    QString wmLocation;
    Ui::wmfinalpage *ui;
    Logger *myLogger;
    Converter *myConverter;
    QStringList *oniSplitCommands;
    // We use shared_ptr because we need the signal and slot mechanism in WmPage,
    // which require inheritance from QObject, which doesn't support copy constructors
    QList<std::shared_ptr<WmPage>> &pages;

private:
    void initializePage();
    void startProcessing();
    void connectSlots();

private slots:
    void openSoundsFolder();
    void catchOSplitProcessingErrors(QString result, int numErrors);
};

#endif // WMFINALPAGE_H
