#include "wmpage.h"

WmPage::WmPage(QWidget *currentTab)
{
    createAndAddPageToTab(currentTab);
}

void WmPage::createAndAddPageToTab(QWidget *currentTab){
    // Adapted from here: http://stackoverflow.com/questions/5258665/how-to-set-number-of-lines-for-an-qtextedit
    // Thanks TonyK
    // Note: not working totally as expected. It isnt resizing correctly for the number of rows.
    std::function<void(QTextEdit*, int)> setNumberOfRows = [](QTextEdit* textEdit, int rows){
        textEdit->setFixedHeight(QFontMetrics(textEdit->font()).lineSpacing() * rows);
    };

    this->pageTab = currentTab;

    QGroupBox *mainTextGroupBox = new QGroupBox(this->pageTab);
    mainTextGroupBox->setTitle("Main Text");

    this->mainText = new QTextEdit(this->pageTab);
    setNumberOfRows(this->mainText, 8);
    this->mainText->setAcceptRichText(false); // block pasting of external formatting
    this->mainText->setWordWrapMode(QTextOption::NoWrap);
    QPalette auxPalette = this->mainText->palette();
    auxPalette.setColor(QPalette::Base, QColor(64,64,64));
    this->mainText->setPalette(auxPalette);

    QVBoxLayout *mainTextGroupBoxLayout = new QVBoxLayout();
    mainTextGroupBoxLayout->addWidget(this->mainText);
    mainTextGroupBox->setLayout(mainTextGroupBoxLayout);

    footerTextGroupBox = new QGroupBox(this->pageTab);
    footerTextGroupBox->setTitle("Footer Text");

    this->footerText = new QTextEdit(footerTextGroupBox);
    setNumberOfRows(this->footerText, 4);
    this->footerText->setAcceptRichText(false); // block pasting of external formatting
    this->footerText->setWordWrapMode(QTextOption::NoWrap);
    this->footerText->setPalette(auxPalette);


    QVBoxLayout *footerTextGroupBoxLayout = new QVBoxLayout();
    footerTextGroupBoxLayout->addWidget(this->footerText);
    footerTextGroupBox->setLayout(footerTextGroupBoxLayout);

    this->middleImage = new QLabel(this->pageTab);
    this->middleImage->setText("No image selected");
    this->middleImage->setFixedSize(140,100);
    this->middleImage->setFrameShape(QFrame::StyledPanel);
    this->middleImage->setWordWrap(true); // allows us to have text in multiple rows
    this->middleImage->setAlignment(Qt::AlignVCenter | Qt::AlignHCenter); // align text at center

    this->addRemoveImageButton = new QToolButton(this->pageTab);
    this->addRemoveImageButton->setToolTip("Click to add an image");
    this->addRemoveImageButton->setIcon(QIcon(":/new/icons/plus.png"));

    QHBoxLayout *imageLayoutCenter = new QHBoxLayout();
    imageLayoutCenter->addSpacerItem(new QSpacerItem(1,1, QSizePolicy::Expanding, QSizePolicy::Fixed));
    imageLayoutCenter->addWidget(this->middleImage);
    imageLayoutCenter->addWidget(this->addRemoveImageButton);
    imageLayoutCenter->addSpacerItem(new QSpacerItem(1,1, QSizePolicy::Expanding, QSizePolicy::Fixed));

    QVBoxLayout *pageLayout = new QVBoxLayout();
    pageLayout->addWidget(mainTextGroupBox);
    pageLayout->addLayout(imageLayoutCenter);
    pageLayout->addWidget(footerTextGroupBox);

    this->pageTab->setLayout(pageLayout);

    // Connect addRemoveImageButton to our slot
    connect(this->addRemoveImageButton, SIGNAL(clicked(bool)), this, SLOT(addRemoveImageButtonTriggered()));
}


QTextEdit& WmPage::getMainText(){
    return *this->mainText;
}

QTextEdit& WmPage::getFooterText(){
    return *this->footerText;
}

QLabel& WmPage::getMiddleImage(){
    return *this->middleImage;
}

void WmPage::hideFooterText(){
    this->footerTextGroupBox->hide();
}

void WmPage::showFooterText(){
    this->footerTextGroupBox->show();
}

void WmPage::addRemoveImageButtonTriggered(){

    if(this->middleImage->pixmap() == nullptr){

        QString selectedImage = QFileDialog::getOpenFileName(this->pageTab,"Choose the image file...","./" , "Image (*.JPG *.JPEG *.PNG)");

        if(!selectedImage.isEmpty()){

            this->middleImage->setText(selectedImage);
            this->middleImage->setToolTip(selectedImage);

            this->middleImage->setPixmap( selectedImage );

            // Thanks bukkfa!
            // http://stackoverflow.com/questions/5653114/display-image-in-qt-to-fit-label-size
            this->middleImage->setScaledContents( true );
            this->addRemoveImageButton->setToolTip("Click to remove the image");
            this->addRemoveImageButton->setIcon(QIcon(":/new/icons/abort.png"));
        }
    }
    else{
        this->middleImage->setToolTip("");
        this->middleImage->clear();
        this->middleImage->setText("No image selected");
        this->addRemoveImageButton->setToolTip("Click to add an image");
        this->addRemoveImageButton->setIcon(QIcon(":/new/icons/plus.png"));
    }
}
