#include "wmwizard.h"

WmWizard::WmWizard(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger)
:AbstractWizard(appDir, workspaceWizardLocation, vagoSettings, myLogger, true)
{
    this->bgImagesLocation=this->workspaceWizardLocation+"/WindowMessages";
}

void WmWizard::exec(){

    WmSetupPage *setupPage = new WmSetupPage();
    WmFormatPage *formatPage = new WmFormatPage(this->myLogger);
    WmFinalPage *finalPage = new WmFinalPage(this->appDir, this->bgImagesLocation, this->myLogger, formatPage->getCurrentPages());

    this->myWizard.addPage
    (
        createIntroPage
        (
            "Welcome to the Oni Window Messages Wizard.\n"
            "This wizard will allow you to create in a few and simple steps Oni Window Messages (DPge, HPge etc).\n"
            "This Window Messages are used to display information to the player in consoles, diary, help, item / weapon pages etc."
        )
    );
    this->myWizard.addPage(setupPage);
    this->myWizard.addPage(formatPage);
    this->myWizard.addPage(finalPage);

    showWizard("Window Messages Wizard", ":/new/icons/windowmessages.png");
}

void WmWizard::beforeClose(QDialog::DialogCode){

}
