#ifndef SOUNDWIZARD_H
#define SOUNDWIZARD_H

// System includes
#include <QString>
#include <QWizard>
#include <QWizardPage>
#include <QLabel>
#include <QDesktopWidget>
#include <QVBoxLayout>
#include <QPushButton>

// Local includes
#include "util.h"
#include "abstractwizard.h"
#include "logger.h"
#include "soundpage2.h"
#include "soundpage3.h"
#include "soundpage4.h"
#include "soundpage5.h"
#include "soundpagefinal.h"

class SoundWizard: public AbstractWizard
{
protected:
    SoundWizard(QString appLocation, QString workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger, QHash<QString, QString> *commandMap);
    void exec();
    QHash<QString, QString> *commandMap;
private:
    QString soundsLocation;
    void beforeClose(QDialog::DialogCode resultStatus);
};

#endif // SOUNDWIZARD_H
