unit WhatLinksHere;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Template;

type
  TForm_WhatLinksHere = class(TForm)
    list: TListBox;
    label_what: TLabel;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure listDblClick(Sender: TObject);
  private
  public
    SenderForm: TForm_ToolTemplate;
    ConID: Integer;
    FileID: Integer;
  end;

var
  Form_WhatLinksHere: TForm_WhatLinksHere;

implementation
{$R *.dfm}
uses ConnectionManager, Access_OUP_ADB, TypeDefs, Functions, Main;

{ TForm_WhatLinksHere }

procedure TForm_WhatLinksHere.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  Form_Main.Enabled := True;
  Visible := False;
  CanClose := False;
end;

procedure TForm_WhatLinksHere.FormShow(Sender: TObject);
var
  fileinfo: TFileInfo;
  links: TLinks;
  i: Integer;
  fullname: String;
begin
  Form_Main.Enabled := False;
  list.Items.Clear;
  fileinfo := ConManager.Connection[ConID].GetFileInfo(FileID);
  label_what.Caption := FormatNumber(fileinfo.ID, 5, '0') + '-' +
      fileinfo.Name + '.' + fileinfo.Extension;
  links := TAccess_OUP_ADB(ConManager.Connection[ConID]).GetLinksToFile(fileinfo.ID);
  if Length(links.ByID) > 0 then
    for i := 0 to High(links.ByID) do
    begin
      fileinfo := ConManager.Connection[ConID].GetFileInfo(links.ByID[i].Destination);
      fullname := FormatNumber(fileinfo.ID, 5, '0') + '-' + fileinfo.Name + '.' + fileinfo.Extension;
      list.Items.Add(fullname + ' (Offset 0x' + IntToHex(links.ByID[i].SrcOffset, 8) + ')');
    end;
end;

procedure TForm_WhatLinksHere.listDblClick(Sender: TObject);
var
  id: Integer;
begin
  id := ConManager.Connection[ConID].ExtractFileIDOfName(list.Items.Strings[list.ItemIndex]);
  SenderForm.SelectFileID(ConID, id);
  Form_Main.Enabled := True;
  Visible := False;
end;

end.
