package net.oni2.platformtools;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import net.oni2.platformtools.applicationinvoker.ApplicationInvoker;
import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;

/**
 * @author Christian Illy
 */
public class PlatformInformation {

	/**
	 * @author Christian Illy
	 */
	public enum Architecture {
		/**
		 * 32 bit
		 */
		X86,
		/**
		 * 64 bit
		 */
		AMD64,
		/**
		 * PPC
		 */
		PPC
	}

	/**
	 * @author Christian Illy
	 */
	public enum Platform {
		/**
		 * Running Windows
		 */
		WIN,
		/**
		 * Running MacOS
		 */
		MACOS,
		/**
		 * Running a Linux
		 */
		LINUX,
		/**
		 * Unknown OS
		 */
		UNKNOWN
	}

	private static Platform platform = null;
	private static Architecture architecture = null;

	/**
	 * @return Processor architecture
	 */
	public static Architecture getArchitecture() {
		if (architecture == null) {
			Vector<String> params = new Vector<String>();
			ApplicationInvocationResult res = null;

			switch (getPlatform()) {
				case WIN:
					String arch = System.getenv("PROCESSOR_ARCHITECTURE")
							.toLowerCase();
					if (arch.startsWith("x86"))
						architecture = Architecture.X86;
					architecture = Architecture.AMD64;
					break;
				case MACOS:
					params.add("-m");
					try {
						res = ApplicationInvoker.executeAndWait(
								EExeType.OSBINARY, null, new File("uname"),
								params, false);
					} catch (IOException e) {
						e.printStackTrace();
					} catch (ERuntimeNotInstalledException e) {
						e.printStackTrace();
					}
					architecture = Architecture.AMD64;
					if (res != null) {
						if (res.output.get(0).toLowerCase().contains("power macintosh"))
							architecture = Architecture.PPC;
					}
					break;
				case LINUX:
					params.add("LONG_BIT");
					try {
						res = ApplicationInvoker.executeAndWait(
								EExeType.OSBINARY, null, new File("getconf"),
								params, false);
					} catch (IOException e) {
						e.printStackTrace();
					} catch (ERuntimeNotInstalledException e) {
						e.printStackTrace();
					}
					architecture = Architecture.X86;
					if (res != null) {
						if (res.output.get(0).equals("64"))
							architecture = Architecture.AMD64;
					}
					break;
				default:
					architecture = null;
			}
		}
		return architecture;
	}

	/**
	 * @return The operating system running on
	 */
	public static Platform getPlatform() {
		if (platform == null) {
			String os = System.getProperty("os.name").toLowerCase();
			if (os.startsWith("win"))
				platform = Platform.WIN;
			else if (os.startsWith("linux"))
				platform = Platform.LINUX;
			else if (os.startsWith("mac") || os.startsWith("darwin"))
				platform = Platform.MACOS;
			else
				platform = Platform.UNKNOWN;
		}
		return platform;
	}

}
