/*
 * Decompiled with CFR 0.152.
 */
package net.oni2;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;

public class ProxySettings
implements Serializable {
    private static final long serialVersionUID = 7764207071836441954L;
    private static ProxySettings instance = new ProxySettings();
    private boolean useProxy = false;
    private String hostOrIp = "";
    private int port = 8080;
    private transient boolean validated = false;
    private transient boolean validatedOk = false;

    public Proxy getProxy() {
        if (!this.useProxy) {
            return Proxy.NO_PROXY;
        }
        if (!this.validated) {
            this.validate();
        }
        if (!this.validatedOk) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.hostOrIp, this.port));
    }

    public boolean validate() {
        if (this.validated) {
            return this.validatedOk;
        }
        this.validated = true;
        if (this.isValid()) {
            try {
                URLConnection con = new URL(String.format("http://%s:%d", this.hostOrIp, this.port)).openConnection();
                con.setConnectTimeout(1000);
                con.connect();
                this.validatedOk = true;
                return true;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.validatedOk = false;
        return false;
    }

    public boolean isValid() {
        return this.hostOrIp != null && this.port > 0;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean use) {
        this.useProxy = use;
    }

    public String getHostOrIp() {
        return this.hostOrIp;
    }

    public void setHostOrIp(String hoi) {
        this.validated = false;
        this.hostOrIp = hoi;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.validated = false;
        this.port = port;
    }

    public static ProxySettings getInstance() {
        return instance;
    }

    private static XStream getXStream() {
        XStream xs = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xs.alias("Proxy", ProxySettings.class);
        return xs;
    }

    public void serializeToFile(File settingsFile) {
        try {
            FileOutputStream fos = new FileOutputStream(settingsFile);
            XStream xs = ProxySettings.getXStream();
            xs.toXML((Object)this, (OutputStream)fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deserializeFromFile(File settingsFile) {
        try {
            FileInputStream fis = new FileInputStream(settingsFile);
            XStream xs = ProxySettings.getXStream();
            Object obj = xs.fromXML((InputStream)fis);
            if (obj instanceof ProxySettings) {
                instance = (ProxySettings)obj;
            }
            fis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

