/*
 * Decompiled with CFR 0.152.
 */
package net.oni2.aeinstaller.updater.backend;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class Paths {
    public static boolean useWorkingDirectory = false;

    public static File getInstallerPath() {
        String jarPath = Paths.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        jarPath = jarPath.replaceAll("\\+", "%2B");
        String decodedPath = null;
        try {
            decodedPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new File(decodedPath).getParentFile();
    }

    public static File getProxySettingsFilename() {
        return new File(Paths.getPrefsPath(), "AEI-ProxySettings.xml");
    }

    public static File getPrefsPath() {
        if (useWorkingDirectory) {
            String wd = System.getProperty("user.dir");
            return new File(wd);
        }
        return Paths.getInstallerPath();
    }

    public static File getDownloadPath() {
        return new File(Paths.getTempPath(), "downloads");
    }

    public static File getTempPath() {
        return new File(System.getProperty("java.io.tmpdir"), "oni_aei");
    }
}

