/*
 * Decompiled with CFR 0.152.
 */
package net.oni2.platformtools.applicationinvoker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;
import net.oni2.platformtools.applicationinvoker.DotNet;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;
import net.oni2.platformtools.applicationinvoker.Java;
import net.oni2.platformtools.applicationinvoker.Wine;

public class ApplicationInvoker {
    private static Vector<String> buildCommandLine(EExeType exeType, File program, Vector<String> params, boolean ignoreFileNotFound) throws ERuntimeNotInstalledException, FileNotFoundException {
        if (!ignoreFileNotFound && program.getParentFile() != null && !program.exists()) {
            throw new FileNotFoundException();
        }
        Vector<String> cmdLine = new Vector<String>();
        block0 : switch (exeType) {
            case DOTNET: {
                if (!DotNet.isInstalled()) {
                    throw new ERuntimeNotInstalledException("No .NET runtime found");
                }
                if (PlatformInformation.getPlatform() != PlatformInformation.Platform.WIN) {
                    cmdLine.add(DotNet.getRuntimeExe().getPath());
                }
                cmdLine.add(program.getPath());
                break;
            }
            case JAR: {
                if (!Java.isInstalled()) {
                    throw new ERuntimeNotInstalledException("JRE not found");
                }
                cmdLine.add(Java.getRuntimeExe().getPath());
                cmdLine.add("-jar");
                cmdLine.add(program.getPath());
                break;
            }
            case OSBINARY: {
                cmdLine.add(program.getPath());
                break;
            }
            case WINEXE: {
                switch (PlatformInformation.getPlatform()) {
                    case LINUX: {
                        if (!Wine.isInstalled()) {
                            throw new ERuntimeNotInstalledException("Can not run Windows executable because Wine was not found");
                        }
                        cmdLine.add(Wine.getRuntimeExe().getPath());
                        cmdLine.add(program.getPath());
                        break block0;
                    }
                    case MACOS: {
                        throw new ERuntimeNotInstalledException("Can not run a Windows executable on MacOS");
                    }
                    case WIN: {
                        cmdLine.add(program.getPath());
                        break block0;
                    }
                    case UNKNOWN: {
                        throw new ERuntimeNotInstalledException("Can not run a Windows executable on an unidentified system");
                    }
                }
            }
        }
        if (params != null) {
            cmdLine.addAll(params);
        }
        return cmdLine;
    }

    public static ApplicationInvocationResult executeAndWait(EExeType exeType, File workingDirectory, File program, Vector<String> params, boolean ignoreFileNotFound) throws ERuntimeNotInstalledException, FileNotFoundException, IOException {
        return ApplicationInvoker.executeAndWait(workingDirectory, ApplicationInvoker.buildCommandLine(exeType, program, params, ignoreFileNotFound));
    }

    public static void execute(EExeType exeType, File workingDirectory, File program, Vector<String> params, boolean ignoreFileNotFound) throws ERuntimeNotInstalledException, FileNotFoundException {
        ApplicationInvoker.execute(ApplicationInvoker.buildCommandLine(exeType, program, params, ignoreFileNotFound), workingDirectory);
    }

    private static ApplicationInvocationResult executeAndWait(File workingDirectory, Vector<String> cmdLine) throws IOException {
        String line;
        long start = new Date().getTime();
        ProcessBuilder pb = new ProcessBuilder(cmdLine);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        if (workingDirectory != null) {
            pb.directory(workingDirectory);
        }
        InputStream is = proc.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        Vector<String> lines = new Vector<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new ApplicationInvocationResult(proc.exitValue(), cmdLine, lines, (int)(new Date().getTime() - start));
    }

    private static void execute(List<String> cmd, File workingDirectory) {
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            if (workingDirectory != null) {
                pb.directory(workingDirectory);
            }
            pb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

