/*
 * Decompiled with CFR 0.152.
 */
package net.oni2.svnaccess;

import java.io.File;
import java.util.Vector;
import net.oni2.ProxySettings;
import net.oni2.svnaccess.DirEntryHandler;
import net.oni2.svnaccess.LogEntryHandler;
import net.oni2.svnaccess.SVNUpdateListener;
import net.oni2.svnaccess.UpdateEventHandler;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVN {
    SVNClientManager svnCManager = null;

    private void setup() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private void setProxy(BasicAuthenticationManager authMan) {
        ProxySettings prox = ProxySettings.getInstance();
        if (prox.validate() && prox.isUseProxy()) {
            authMan.setProxy(prox.getHostOrIp(), prox.getPort(), null, null);
        }
    }

    private BasicAuthenticationManager getAuthManager() {
        BasicAuthenticationManager auth = new BasicAuthenticationManager(new SVNAuthentication[0]);
        this.setProxy(auth);
        return auth;
    }

    private BasicAuthenticationManager getAuthManager(String username, String password) {
        BasicAuthenticationManager auth = new BasicAuthenticationManager(username, password);
        this.setProxy(auth);
        return auth;
    }

    public SVN() {
        this.setup();
        this.svnCManager = SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions(true), this.getAuthManager());
    }

    public SVN(String username, String password) {
        this.setup();
        this.svnCManager = SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions(true), this.getAuthManager(username, password));
    }

    public boolean updateWC(String reposUrl, File wcDir, SVNUpdateListener listener) throws Exception {
        SVNURL repos = SVNURL.parseURIEncoded(reposUrl);
        if (wcDir.exists()) {
            int rev = this.pathIsWCof(repos, wcDir);
            if (rev < 0) {
                throw new Exception("Destination path exists but is not a Working Copy of the SVN");
            }
            return this.update(repos, wcDir, rev, listener);
        }
        return this.checkout(repos, wcDir, listener);
    }

    public int checkSVN(String reposUrl, File wcDir) throws Exception {
        SVNURL repos = SVNURL.parseURIEncoded(reposUrl);
        if (wcDir.exists()) {
            int localRev = this.pathIsWCof(repos, wcDir);
            if (localRev < 0) {
                if (wcDir.listFiles().length > 0) {
                    throw new Exception("Destination path exists but is not a Working Copy of the SVN");
                }
                wcDir.delete();
                return -1;
            }
            int remoteRev = this.getRemoteHeadRevision(repos);
            if (remoteRev > localRev) {
                return 1;
            }
            if (remoteRev < 0) {
                return -2;
            }
            if (this.getMissingFiles(wcDir)) {
                return 2;
            }
            return 0;
        }
        return -1;
    }

    private boolean getMissingFiles(File wcDir) {
        try {
            final Vector files = new Vector();
            this.svnCManager.getStatusClient().doStatus(wcDir, null, SVNDepth.INFINITY, false, false, false, false, new ISVNStatusHandler(){

                @Override
                public void handleStatus(SVNStatus status) throws SVNException {
                    SVNStatusType stat = status.getCombinedNodeAndContentsStatus();
                    if (stat == SVNStatusType.MISSING || stat == SVNStatusType.STATUS_MISSING) {
                        files.add(status.getFile().getPath());
                    }
                }
            }, null);
            return files.size() > 0;
        }
        catch (SVNException e) {
            e.printStackTrace();
            return false;
        }
    }

    private int getRemoteHeadRevision(SVNURL reposUrl) {
        try {
            SVNInfo info = this.svnCManager.getWCClient().doInfo(reposUrl, SVNRevision.HEAD, SVNRevision.HEAD);
            return (int)info.getRevision().getNumber();
        }
        catch (SVNException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int pathIsWCof(SVNURL reposUrl, File wcDir) {
        if (wcDir.exists()) {
            try {
                SVNInfo info = this.svnCManager.getWCClient().doInfo(wcDir, SVNRevision.WORKING);
                if (info.getURL().equals(reposUrl)) {
                    return (int)info.getRevision().getNumber();
                }
            }
            catch (SVNException e) {
                System.err.println("Error while getting information of working copy for the location '" + reposUrl + "': " + e.getMessage());
                e.printStackTrace();
            }
        }
        return -1;
    }

    private Vector<String> getUpdatedFilesInRepository(SVNURL reposUrl, int fromRev) {
        Vector<String> list;
        block2: {
            list = new Vector<String>();
            try {
                this.svnCManager.getLogClient().doLog(reposUrl, new String[]{reposUrl.getPath()}, SVNRevision.HEAD, SVNRevision.create(fromRev + 1), SVNRevision.HEAD, true, true, 0L, (ISVNLogEntryHandler)new LogEntryHandler(list, reposUrl.getPath()));
            }
            catch (Exception e) {
                if (e.getMessage().contains("No such revision ")) break block2;
                System.err.println("Error while getting the list of updated files of the location '" + reposUrl + "': " + e.getMessage());
                e.printStackTrace();
            }
        }
        return list;
    }

    private boolean update(SVNURL reposUrl, File wcDir, int fromRev, SVNUpdateListener listener) throws Exception {
        Vector<String> updatedFiles = this.getUpdatedFilesInRepository(reposUrl, fromRev);
        this.svnCManager.getUpdateClient().setEventHandler(new UpdateEventHandler(updatedFiles, listener));
        try {
            this.svnCManager.getUpdateClient().doUpdate(wcDir, SVNRevision.HEAD, SVNDepth.INFINITY, true, true);
            return true;
        }
        catch (Exception e) {
            System.err.println("Error while updating the working copy for the location '" + reposUrl + "': " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private Vector<String> getFilesInRepository(SVNURL reposUrl) throws Exception {
        Vector<String> list = new Vector<String>();
        try {
            this.svnCManager.getLogClient().doList(reposUrl, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.INFINITY, -1, (ISVNDirEntryHandler)new DirEntryHandler(list));
        }
        catch (Exception e) {
            System.err.println("Error while getting the list of files of the location '" + reposUrl + "': " + e.getMessage());
            e.printStackTrace();
        }
        return list;
    }

    private boolean checkout(SVNURL reposUrl, File wcDir, SVNUpdateListener listener) throws Exception {
        Vector<String> newFiles = this.getFilesInRepository(reposUrl);
        this.svnCManager.getUpdateClient().setEventHandler(new UpdateEventHandler(newFiles, listener));
        boolean result = false;
        try {
            wcDir.mkdirs();
            this.svnCManager.getUpdateClient().doCheckout(reposUrl, wcDir, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true);
            result = true;
        }
        catch (Exception e) {
            System.err.println("Error while checking out a working copy for the location '" + reposUrl + "': " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }
}

