/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SVNSocketConnection
implements Runnable {
    private Socket mySocket;
    private InetSocketAddress myAddress;
    private int myTimeout;
    private IOException myError;
    private volatile boolean myIsSocketConnected;

    public SVNSocketConnection(Socket socket, InetSocketAddress address, int timeout) {
        this.mySocket = socket;
        this.myAddress = address;
        this.myTimeout = timeout;
        this.myIsSocketConnected = false;
    }

    public IOException getError() {
        return this.myError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSocketConnected() {
        SVNSocketConnection sVNSocketConnection = this;
        synchronized (sVNSocketConnection) {
            if (!this.myIsSocketConnected) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.myIsSocketConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.mySocket.connect(this.myAddress, this.myTimeout);
        }
        catch (IOException e) {
            this.myError = e;
        }
        finally {
            SVNSocketConnection sVNSocketConnection = this;
            synchronized (sVNSocketConnection) {
                this.myIsSocketConnected = true;
                this.notify();
            }
        }
    }
}

