/*
 * Decompiled with CFR 0.152.
 */
package net.oni2.platformtools.applicationinvoker;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;
import net.oni2.platformtools.PlatformInformation;
import net.oni2.platformtools.WinRegistry;
import net.oni2.platformtools.applicationinvoker.ApplicationInvocationResult;
import net.oni2.platformtools.applicationinvoker.ApplicationInvoker;
import net.oni2.platformtools.applicationinvoker.EExeType;
import net.oni2.platformtools.applicationinvoker.ERuntimeNotInstalledException;

public class DotNet {
    private static File mono = null;
    private static int isInst = -1;

    public static boolean isInstalled() {
        if (isInst < 0) {
            isInst = 0;
            switch (PlatformInformation.getPlatform()) {
                case WIN: {
                    try {
                        Map<String, String> m;
                        int view = 512;
                        if (PlatformInformation.getArchitecture() == PlatformInformation.Architecture.AMD64) {
                            view = 256;
                        }
                        isInst = (m = WinRegistry.readStringValues(-2147483646, "Software\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727", view)) != null ? 1 : 0;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        if (e.getMessage().equals("Registry access not supported (not a Windows OS?).")) break;
                        e.printStackTrace();
                    }
                    break;
                }
                case MACOS: 
                case LINUX: {
                    Vector<String> params = new Vector<String>();
                    params.add("mono");
                    ApplicationInvocationResult res = null;
                    try {
                        res = ApplicationInvoker.executeAndWait(EExeType.OSBINARY, null, new File("which"), params, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ERuntimeNotInstalledException e) {
                        e.printStackTrace();
                    }
                    if (res == null || res.output.size() <= 0 || !res.output.get(0).startsWith("/") || !res.output.get(0).endsWith("mono")) break;
                    isInst = 1;
                    mono = new File(res.output.get(0));
                    break;
                }
                default: {
                    isInst = 0;
                }
            }
        }
        return isInst == 1;
    }

    public static File getRuntimeExe() {
        if (PlatformInformation.getPlatform() != PlatformInformation.Platform.WIN) {
            return mono;
        }
        return null;
    }
}

