#ifndef WMSETUPPAGE_H
#define WMSETUPPAGE_H

#include <QWizardPage>

#include "utilvago.h"

namespace Ui {
class WmSetupPage;
}

enum class WINDOW_TYPE{
    OBJECTIVE = 0,
    TEXT_CONSOLE,
    WEAPON,
    ITEM,
    DIARY,
    HELP,
    ENUM_END
};

class WmSetupPage : public QWizardPage
{
    Q_OBJECT
public:
    explicit WmSetupPage(QWidget *parent = 0);
    ~WmSetupPage();
    
private slots:
    bool validatePage();

    void on_leLevelId_textChanged(const QString &arg1);

    void on_lePageNumber_textChanged(const QString &arg1);

    void on_cbWindowType_currentTextChanged(const QString &arg1);

    void on_leWeaponClassName_textChanged(const QString &arg1);

private:
    Ui::WmSetupPage *ui;
private:
    void generateDiaryFileName();
    QString getWindowTypeDescription(const WINDOW_TYPE wt);
};

#endif // WMSETUPPAGE_H
