#ifndef WIZARDFACTORY_H
#define WIZARDFACTORY_H

#include "soundwizard.h"

// This template class allows us to create wizards in the heap which auto-delete themselves once finished
template<typename T>
class WizardFactory : public T
{
public:
    static void startInstance(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger){
        (new WizardFactory<T>(appDir, workspaceWizardLocation, vagoSettings, myLogger))->exec();
    }
private:
    // We need to have a constructor to be able to acess "exec" protected function
    WizardFactory
    (
            const QString &appDir,
            const QString &workspaceWizardLocation,
            QSettings *vagoSettings,
            Logger *myLogger
    ):T(appDir, workspaceWizardLocation, vagoSettings, myLogger){}
};

// Specialization for SoundWizard (it receives extra variables)
template<>
class WizardFactory<SoundWizard> : public SoundWizard
{
public:
    static void startInstance(const QString &appDir, const QString &workspaceWizardLocation, QSettings *vagoSettings, Logger *myLogger, QHash<QString, QString> *commandMap){
        (new WizardFactory(appDir, workspaceWizardLocation, vagoSettings, myLogger, commandMap))->exec();
    }
private:
    WizardFactory
    (
            const QString &appDir,
            const QString &workspaceWizardLocation,
            QSettings *vagoSettings,
            Logger *myLogger,
            QHash<QString, QString> *commandMap
    ):SoundWizard(appDir, workspaceWizardLocation, vagoSettings, myLogger, commandMap){}
};





#endif // WIZARDFACTORY_H
