#include "soundwizard.h"

SoundWizard::SoundWizard(QString appDir, QString workspaceWizardLocation, QSettings *vagoSettings, QHash<QString, QString> *commandMap)
    :AbstractWizard(appDir, workspaceWizardLocation, vagoSettings, true)
{
    this->appDir=appDir;
    this->soundsLocation=this->workspaceWizardLocation+"/Sounds";
    this->commandMap=commandMap;
}
void SoundWizard::exec(){

    SoundPage2 *page2 = new SoundPage2(this->appDir);
    SoundPage3 *page3 = new SoundPage3();
    SoundPage4 *page4 = new SoundPage4();
    SoundPage5 *page5 = new SoundPage5();
    SoundPageFinal *pageFinal = new SoundPageFinal(this->appDir, this->soundsLocation,page2->soundTable, this->commandMap);

    this->myWizard.addPage
    (
        createIntroPage
        (
            "Welcome to the Oni Sound wizard.\n"
            "This wizard will allow you to convert in a few and simple steps sounds to oni format."
        )
    );

    this->myWizard.addPage(page2);
    this->myWizard.addPage(page3);
    this->myWizard.addPage(page4);
    this->myWizard.addPage(page5);
    this->myWizard.addPage(pageFinal);

    this->myWizard.setWindowTitle("Sound wizard");

    showWizard("Sound wizard", ":/new/icons/sound.png");
}

void SoundWizard::beforeClose(QDialog::DialogCode){

}
