#include "utilvago.h"

namespace UtilVago{

void openLogFile(){
    QDesktopServices::openUrl(QUrl("file:///"+getAppPath()+"/"+GlobalVars::AppLogName));
}

void showAndLogWarningPopUp(const QString &message){
    LOG_WARNING << message;

    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Warning);
    msgBox.setText(message);
    msgBox.exec();
}

//Same of above but allow open log file (doesn't write in log file!!)
void showWarningPopUpLogButton(const QString &message){
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Warning);
    msgBox.setText(message);
    QPushButton *viewb = msgBox.addButton("View log", QMessageBox::ActionRole);
    msgBox.setStandardButtons(QMessageBox::Close);
    msgBox.exec();
    if(msgBox.clickedButton() == (QAbstractButton*)(viewb)){
        openLogFile();
    }
}

//Same of above but also writtes directly to the log file the error
void showAndLogWarningPopUpLogButton(const QString &message){

    LOG_WARNING << message;

    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Warning);
    msgBox.setText(message);
    QPushButton *viewb = msgBox.addButton("View log", QMessageBox::ActionRole);
    msgBox.setStandardButtons(QMessageBox::Close);
    msgBox.exec();
    if(msgBox.clickedButton() == (QAbstractButton*)(viewb)){
        openLogFile();
    }
}

void showAndLogErrorPopUp(const QString &message){

    LOG_ERROR << message;

    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
}

//Same of above but allow open log file (doesn't write in log file!!)
void showErrorPopUpLogButton(const QString &message){
    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    QPushButton *viewb = msgBox.addButton("View log", QMessageBox::ActionRole);
    msgBox.setStandardButtons(QMessageBox::Close);
    msgBox.exec();
    if(msgBox.clickedButton() == (QAbstractButton*)(viewb)){
        openLogFile();
    }
}

//Same of above but also writtes directly to the log file the error
void showAndLogErrorPopUpLogButton(const QString &message){

    LOG_ERROR << message;

    QMessageBox msgBox;
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    QPushButton *viewb = msgBox.addButton("View log", QMessageBox::ActionRole);
    msgBox.setStandardButtons(QMessageBox::Close);
    msgBox.exec();
    if(msgBox.clickedButton() == (QAbstractButton*)(viewb)){
        openLogFile();
    }
}

/**
  Gets application directory. In mac os gets the .app directory
  **/
QString getOSIndependentAppPath(){
#ifdef Q_OS_MAC
    QDir dir = QDir(QCoreApplication::applicationDirPath());
    if(dir.absolutePath().contains(".app")){ // include bundle, but we don't want it
        dir.cdUp();
        dir.cdUp();
        dir.cdUp();
    }
    return dir.absolutePath();
#else
    return  QDir::currentPath();
#endif
}

QString getAppPath(){
    return getOSIndependentAppPath();
}

// Absolute paths
QString getOniSplitExecutableAbsolutePath(){
    return getAppPath() + "/" + GlobalVars::ToolsFolder + "/" + GlobalVars::OniSplitString;
}

QString getXmlToolsExecutableAbsolutePath(){
    return getAppPath() + "/" + GlobalVars::ToolsFolder + "/" + GlobalVars::XmlToolsString;
}

// Executables (includes mono if necessary)
QString getOniSplitExecutable(){

#ifdef Q_OS_MAC
    return getMonoExecutablePath() + " " + Util::String::insertQuotes(getOniSplitExecutableAbsolutePath());
#else
    return Util::String::insertQuotes(getOniSplitExecutableAbsolutePath());
#endif
}

QString getXmlToolsExecutable(){
    return Util::String::insertQuotes(getXmlToolsExecutableAbsolutePath());
}

#ifdef Q_OS_MAC
QString getMonoExecutablePath(){

    // Only way that I found to get mono working in 10.11
    QString possibleMonoDir = "/usr/local/bin/mono";
    QFileInfo checkFile(possibleMonoDir);

    if (checkFile.exists() && checkFile.isFile()) {
        return possibleMonoDir;
    } else {
        return "mono";
    }

}
#endif

QString getDateTimeFormatForFilename(const QDateTime &currentDateTime){
    return currentDateTime.toString("yyyy-MM-dd_hh-mm-ss");
}

}
