#ifndef UTILVAGO_H
#define UTILVAGO_H

#include <util.h>
#include <cpp17optional/optional.hpp>
#include <plog/Log.h>
#include <plog/Converters/NativeEOLConverter.h>

#include <QDateTime>

namespace GlobalVars{

const QString AppVersion="1.4";
const QString LastCompatibleVersion = "1.4";
const QString ToolsFolder = "tools";
const QString OniSplitString="OniSplit.exe";
#ifdef Q_OS_WIN
const QString XmlToolsString="XmlTools.exe";
#else
const QString XmlToolsString="XmlTools";
#endif

#ifdef Q_OS_WIN
const QString OniExe="Oni.exe";
#else
const QString OniExe="Oni.app/Contents/MacOS/Oni";
#endif

const QString AppLogName="logVago.txt";
const QString BuiltOniSplitVersion="0.9.96.0";
const QString BuiltXmlToolsVersion="2.0c";
const QString ModsDomain="mods.oni2.net";
#ifdef Q_OS_WIN
const QString VagoNode = "247";
#else
const QString VagoNode = "277";
#endif
const QString VagoCheckUpdatesUrl="http://"+ModsDomain+"/?q=api/node/"+VagoNode+".json";
const QString VagoWebUrl="http://"+ModsDomain+"/node/"+VagoNode;
const QString VagoTemporaryDir=QDir::tempPath()+"/VagoTemp";
const QString HelpDir="help";
const int DefaultWindowWidth=800;
const int DefaultWindowHeight=600;
const char OniSplitProcSeparator=';';
}

/**
  Utilities functions (Vago specific)
  **/
namespace UtilVago{
void openLogFile();
void showAndLogWarningPopUp(const QString &message);
void showWarningPopUpLogButton(const QString &message);
void showAndLogWarningPopUpLogButton(const QString &message);
void showAndLogErrorPopUp(const QString &message);
void showErrorPopUpLogButton(const QString &message);
void showAndLogErrorPopUpLogButton(const QString &message);
QString getOSIndependentAppPath();
QString getAppPath();
QString getOniSplitExecutableAbsolutePath();
QString getXmlToolsExecutableAbsolutePath();
QString getOniSplitExecutable();
QString getXmlToolsExecutable();
#ifdef Q_OS_MAC
QString getMonoExecutablePath();
#endif
QString getDateTimeFormatForFilename(const QDateTime &currentDateTime);
}

#endif // UTILVAGO_H
