#include "wmsetuppage.h"
#include "ui_wmsetuppage.h"

WmSetupPage::WmSetupPage(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::WmSetupPage)
{
    ui->setupUi(this);

    this->setTitle("Type of Window");
    this->setSubTitle("Choose here what kind of pages do you want to create, to be displayed in the game.");

    // Initialize combobox (hacky!)
    for(int i=0; i<static_cast<int>(WINDOW_TYPE::ENUM_END); i++){
        ui->cbWindowType->addItem(getWindowTypeDescription(static_cast<WINDOW_TYPE>(i)));
    }

    //Register fields to be accessible in another pages //Not using mandatory field, it would require empty verification too...
    registerField("cbWindowType", ui->cbWindowType);
    registerField("leLevelId", ui->leLevelId);
    registerField("leFileName", ui->leFileName);
    registerField("lePageNumber", ui->lePageNumber);
    registerField("leWeaponClassName", ui->leWeaponClassName);
    registerField("cbIsLearnedMove", ui->cbIsLearnedMove);
}

WmSetupPage::~WmSetupPage()
{
    delete ui;
}

bool WmSetupPage::validatePage(){

    QStringList stringsToCheck;

    stringsToCheck << ui->leFileName->text();

    if((ui->lePageNumber->isEnabled())){
        stringsToCheck << ui->lePageNumber->text();
    }
    if((ui->leLevelId->isEnabled())){
        stringsToCheck << ui->leLevelId->text();
    }
    if((ui->leWeaponClassName->isEnabled())){
        stringsToCheck << ui->leWeaponClassName->text();
    }

    if(Util::Validation::checkEmptySpaces(stringsToCheck)){
        Util::Dialogs::showError("You need to fill all fields first!");
        return false;
    }

    return true;
}



void WmSetupPage::on_leLevelId_textChanged(const QString &arg1)
{
    if(arg1.trimmed().isEmpty()){
        return;
    }

    if(!Util::Validation::isStringInteger(arg1)){
        Util::Dialogs::showError("The level id inputted is invalid! It must be a number.");
        return;
    }

    switch(static_cast<WINDOW_TYPE>(ui->cbWindowType->currentIndex())){
    case WINDOW_TYPE::OBJECTIVE:
        ui->leFileName->setText(QString("OPgelevel_") + arg1.trimmed());
        break;
    case  WINDOW_TYPE::DIARY:
        generateDiaryFileName();
        break;
    case  WINDOW_TYPE::TEXT_CONSOLE:
        ui->leFileName->setText(QString("TxtClevel_") + arg1.trimmed());
        break;
    case  WINDOW_TYPE::HELP:
    case  WINDOW_TYPE::WEAPON:
    case  WINDOW_TYPE::ITEM:
    case  WINDOW_TYPE::ENUM_END:
        break;
    }
}

void WmSetupPage::on_lePageNumber_textChanged(const QString &arg1)
{
    if(arg1.trimmed().isEmpty()){
        return;
    }

    if(!Util::Validation::isStringInteger(arg1)){
        Util::Dialogs::showError("The page number inputted is invalid! It must be a number.");
        return;
    }

    switch(static_cast<WINDOW_TYPE>(ui->cbWindowType->currentIndex())){
    case  WINDOW_TYPE::DIARY:
        generateDiaryFileName();
        break;
    case  WINDOW_TYPE::ITEM:
        ui->leFileName->setText("IPge");
        break;
    case  WINDOW_TYPE::OBJECTIVE:
    case  WINDOW_TYPE::TEXT_CONSOLE:
    case  WINDOW_TYPE::HELP:
    case  WINDOW_TYPE::WEAPON:
    case  WINDOW_TYPE::ENUM_END:
        break;
    }

}

void WmSetupPage::on_cbWindowType_currentTextChanged(const QString &arg1)
{
    // when we hide the widgets qt will left some empty space, to remove this space we remove and add also the widgets:
    // http://stackoverflow.com/questions/17986164/how-to-removing-remaining-spacing-after-hide-a-row-in-qformlayout

    ui->leLevelId->setEnabled(false);
    ui->lePageNumber->setEnabled(false);
    ui->leWeaponClassName->setEnabled(false);
    ui->cbIsLearnedMove->setEnabled(false);

    if(arg1 == getWindowTypeDescription(WINDOW_TYPE::DIARY)){
        ui->leLevelId->setEnabled(true);
        ui->lePageNumber->setEnabled(true);
        ui->cbIsLearnedMove->setEnabled(true);
    }
    else if(arg1 == getWindowTypeDescription(WINDOW_TYPE::WEAPON)){
        ui->leWeaponClassName->setEnabled(true);
    }
    else if(arg1 == getWindowTypeDescription(WINDOW_TYPE::ITEM)){
        ui->lePageNumber->setEnabled(true);
    }
    else if(arg1 == getWindowTypeDescription(WINDOW_TYPE::HELP)){
        ui->leFileName->setText("HPgehelp_pg_01");
    }
    else{
        ui->leLevelId->setEnabled(true);
    }
}

void WmSetupPage::on_leWeaponClassName_textChanged(const QString &arg1)
{
    ui->leFileName->setText(QString("WPge") + arg1.trimmed().replace("ONWC",""));
}

QString WmSetupPage::getWindowTypeDescription(const WINDOW_TYPE wt){
    switch(wt){
    case WINDOW_TYPE::OBJECTIVE:
        return "Objective Page(s) [OPge]";
    case WINDOW_TYPE::TEXT_CONSOLE:
        return "Text Console Pages(s) [TxtC]";
    case WINDOW_TYPE::WEAPON:
        return "Weapon Page(s) [WPge]";
    case WINDOW_TYPE::ITEM:
        return "Item Pages(s) [IPge]";
    case WINDOW_TYPE::DIARY:
        return "Diary Page  [DPge]";
    case WINDOW_TYPE::HELP:
        return "Help Page(s) [HPge]";
    default:
        return "ERROR WINDOW_TYPE ENUM";
    }

}

void WmSetupPage::generateDiaryFileName(){
    ui->leFileName->setText(QString("DPgelev_") + (ui->leLevelId->text().trimmed().length() == 1 ? "0" : "") + ui->leLevelId->text() + "_" + ui->lePageNumber->text());
}
