/*
 *
Copyright (C) 2017  Fábio Bento (random-guy)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#ifndef PROJECTFILEVAGO_H
#define PROJECTFILEVAGO_H

#include "utilvago.h"
#include <pugixml/pugixml.hpp>

class ProjectFileVago
{

public:

    struct ProjectTableRow{
      QString fileFolder;
      QString fromTo;
      QString command;
      bool isDisabled = false;
    };

    struct ProjectTable{
        QVector<ProjectTableRow> rows;
        QString from;
        QString to;
    };

    struct ProjectXMLTable : public ProjectTable{};

    struct ProjectTexturesTable: public ProjectTable{
        QString rbTexturesType;
        bool cbGenMipMaps = false;
        bool cbNoUwrap = false;
        bool cbNoVwrap = false;
        bool cbLarge = false;
        bool cbEnvMap = false;
        QString leEnvMapTexture;
    };

    struct ProjectCharactersTable : public ProjectTable{
        bool cbCellShading = false;
        bool cbNormals = false;
        bool cbStandingPose = false;
        bool cbWithTRBS_ONCC = false;
        QString leTRBS_ONCC;
    };

    struct ProjectObjectsTable : public ProjectTable{
        bool cbTexture = false;
        QString leTextureName;
        bool cbWithAnimation = false;
        QString leAnimationName;
    };

    struct ProjectLevelsTable : public ProjectTable{
        bool cbSpecificFilesLevels = false;
        QString leSpecificFilesLevels;
        bool cbDatLevels = false;
        QString leTargetDatLevels;
        bool cbBnvLevels = false;
        QString leBnvLevels;
        bool cbGridsLevels = false;
        bool cbAdditionalSourcesLevels = false;
        QString leAdditSourcesLevels;
    };

    struct ProjectMiscTable : public ProjectTable{};

    struct ProjectData{
        ProjectXMLTable xmlTable;
        ProjectTexturesTable texturesTable;
        ProjectCharactersTable charactersTable;
        ProjectObjectsTable objectsTable;
        ProjectLevelsTable levelsTable;
        ProjectMiscTable miscTable;
    };

public:
    ProjectFileVago() = delete;
	static ProjectFileVago::ProjectData readProjectDataFromFile(const QString &fileFullPath);
    static void saveProjectDataToFile(const QString &fileFullPath, const ProjectData &newProjectData);
private:
	static void upgradeProjectFileIfNecessary(const QString &filePath);
private:
    static const QString XMLTableName;
    static const QString TexturesTableName;
    static const QString CharactersTableName;
    static const QString ObjectsTableName;
    static const QString LevelsTableName;
    static const QString MiscTableName;
};

#endif // PROJECTFILEVAGO_H
