#include "soundpage4.h"
#include "ui_soundpage4.h"

SoundPage4::SoundPage4(QWidget *parent) :
    QWizardPage(parent),
    ui(new Ui::soundpage4)
{
    ui->setupUi(this);

    //Register fields to be accessible in another pages
    registerField("leVolume", ui->leVolume);
    registerField("leMinVolume", ui->leMinVolume);
    registerField("leMaxVolume", ui->leMaxVolume);
    registerField("lePitch", ui->lePitch);
    registerField("leMinPitch", ui->leMinPitch);
    registerField("leMaxPitch", ui->leMaxPitch);
    registerField("leWeight", ui->leWeight);

    registerField("cbPreventRepeat", ui->cbPreventRepeat);

    registerField("rbStereo22", ui->rbStereo22);
    registerField("rbMono22", ui->rbMono22);
    registerField("rbMono44Pc", ui->rbMono44Pc);
}

bool SoundPage4::validatePage(){
    QStringList leContents;
    leContents << ui->leVolume->text() << ui->leMinVolume->text() << ui->leMaxVolume->text()
               << ui->lePitch->text() << ui->leMinPitch->text() << ui->leMaxPitch->text()
               << ui->leWeight->text();

    if(Util::Validation::checkEmptySpaces(leContents)){
        Util::Dialogs::showError("Please fill all fields first!");
        return false;
    }

    if(Util::Validation::checkIfDoubles(leContents)){
        Util::Dialogs::showError("All fields must contains numbers!");
        return false;
    }

    return true;
}

SoundPage4::~SoundPage4()
{
    delete ui;
}
