#ifndef SOUNDPAGEFINAL_H
#define SOUNDPAGEFINAL_H

#include <QWizardPage>
#include <QDesktopServices>
#include <QUrl>
#include <droptablewidget.h>

#include "xmlprocessor.h"
#include "converter.h"

namespace Ui {
class soundpagefinal;
}

class SoundPageFinal : public QWizardPage
{
    Q_OBJECT
    
public:
    explicit SoundPageFinal(QString AppDir, QString soundsLocation, DropTableWidget *page2Table, QHash<QString, QString> *commandMap, QWidget *parent = 0);
    ~SoundPageFinal();
    
private:
    QString soundsLocation;
    Ui::soundpagefinal *ui;
    DropTableWidget *page2Table;
    XmlProcessor *myXmlProcessor;
    Converter *myConverter;
    QStringList *xmlCommands;
    QStringList *oniSplitCommands;
    QHash<QString, QString> *commandMap;

    void initializePage();
    void startProcessing();
    void connectSlots();

private slots:
    void openSoundsFolder();
    void catchXmlAndOSplitProcessingError(QString result, int numErrors);
};

#endif // SOUNDPAGEFINAL_H
