#ifndef XMLTOOLSINTERFACECOMMANDPREVIEW_H
#define XMLTOOLSINTERFACECOMMANDPREVIEW_H

#include <QMainWindow>
#include <QFile>
#include <QScrollBar>

#include <BasicXMLSyntaxHighlighter/BasicXMLSyntaxHighlighter.h>
#include <LineNumberDisplay/LineNumberDisplay.h>
#include "util.h"

namespace Ui {
class XmlToolsInterfaceCommandPreview;
}

class XmlToolsInterfaceCommandPreview : public QMainWindow
{
    Q_OBJECT

public:
    explicit XmlToolsInterfaceCommandPreview(const QString &currentFileLocation, const QString &previewFileLocation, QWidget *parent = 0);
    ~XmlToolsInterfaceCommandPreview();

private:
    Ui::XmlToolsInterfaceCommandPreview *ui;
    BasicXMLSyntaxHighlighter highlighterCurrentFile;
    BasicXMLSyntaxHighlighter highlighterPreviewFile;
    LineNumberDisplay *lineNumberDisplayCurrentFile;
    LineNumberDisplay *lineNumberDisplayPreviewFile;
    QString currentText;
    QString previewText;
    QStringList currentTextRows;
    QStringList previewTextRows;
    QBrush textEditDefaultBackgroundColor;

private slots:
    void verticalScrollbarMoved(int value);
    void horizontalScrollbarMoved(int value);
    void on_cbWrapText_toggled(bool checked);
    void highlightDifferences();
    void on_checkBox_toggled(bool checked);
};

#endif // XMLTOOLSINTERFACECOMMANDPREVIEW_H
