/*
#     ___  _ _      ___
#    |    | | |    |
# ___|    |   | ___|    PS2DEV Open Source Project.
#----------------------------------------------------------
# (c) 2006 Eugene Plotnikov <e-plotnikov@operamail.com>
# (c) 2005 USB support by weltall
# (c) 2005 HOST support by Ronald Andersson (AKA: dlanor)
# Special thanks to 'bigboss'/PS2Reality for valuable information
# about SifAddCmdHandler function
# Licenced under Academic Free License version 2.0
# Review ps2sdk README & LICENSE files for further details.
#
*/
#include "SMS_IOP.h"
#include "SMS_Data.h"
#include "SMS_Config.h"
#include "SMS_GUI.h"
#include "SMS_Locale.h"
#include "SMS_SIF.h"
#include "SMS_SPU.h"
#include "SMS_Sounds.h"
#include "SMS_RC.h"

#include <kernel.h>
#include <sifrpc.h>
#include <iopheap.h>
#include <iopcontrol.h>
#include <loadfile.h>
#include <sbv_patches.h>
#include <stdio.h>
#include <string.h>
#include <libhdd.h>

unsigned int g_IOPFlags;

static unsigned char s_pSIO2MAN[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:SIO2MAN";
static unsigned char s_pPADMAN [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:PADMAN";
static unsigned char s_pMCMAN  [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:MCMAN";
static unsigned char s_pMCSERV [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:MCSERV";

static unsigned char s_ExecIOP[] __attribute__(   (  aligned( 16 ), section( ".data" )  )   ) = {
	0x7f, 0x45, 0x4c, 0x46, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x80, 0xff, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 
	0x10, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x34, 0x00, 0x20, 0x00, 0x02, 0x00, 0x28, 0x00, 
	0x08, 0x00, 0x07, 0x00, 0x80, 0x00, 0x00, 0x70, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
	0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x40, 0x00, 0x00, 0x00, 0x50, 0x82, 0x00, 0x00, 
	0x40, 0x02, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x21, 0x20, 0x85, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x86, 0xa0, 0x00, 0x00, 0xc2, 0x80, 
	0x00, 0x00, 0xc3, 0x90, 0x08, 0x00, 0x40, 0x10, 0x00, 0x00, 0x00, 0x00, 0x21, 0x10, 0x85, 0x00, 
	0x00, 0x00, 0x43, 0xa0, 0x01, 0x00, 0xc6, 0x24, 0x00, 0x00, 0xc2, 0x80, 0x00, 0x00, 0xc3, 0x90, 
	0xfa, 0xff, 0x40, 0x14, 0x01, 0x00, 0xa5, 0x24, 0x08, 0x00, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
	0xd0, 0xff, 0xbd, 0x27, 0x72, 0x00, 0x02, 0x24, 0x10, 0x00, 0xa2, 0xa3, 0x02, 0x00, 0x02, 0x24, 
	0x2c, 0x00, 0xbf, 0xaf, 0x06, 0x00, 0x82, 0x10, 0x28, 0x00, 0xb0, 0xaf, 0x2c, 0x00, 0xbf, 0x8f, 
	0x28, 0x00, 0xb0, 0x8f, 0x01, 0x00, 0x02, 0x24, 0x08, 0x00, 0xe0, 0x03, 0x30, 0x00, 0xbd, 0x27, 
	0x04, 0x00, 0xa2, 0x8c, 0x6f, 0x00, 0x03, 0x24, 0x11, 0x00, 0xa3, 0xa3, 0x00, 0x00, 0x45, 0x80, 
	0xc7, 0xff, 0x03, 0x24, 0x42, 0x00, 0xa3, 0x10, 0xd1, 0xff, 0x02, 0x24, 0xf3, 0xff, 0xa2, 0x14, 
	0x6d, 0x00, 0x02, 0x24, 0x10, 0x00, 0xa4, 0x27, 0x04, 0x00, 0x05, 0x24, 0x3a, 0x00, 0x06, 0x24, 
	0x00, 0x00, 0x00, 0x0c, 0x12, 0x00, 0xa2, 0xa3, 0x30, 0x00, 0x02, 0x24, 0x00, 0x00, 0x06, 0x3c, 
	0x40, 0x02, 0xc6, 0x24, 0x10, 0x00, 0xa4, 0x27, 0x05, 0x00, 0x05, 0x24, 0x03, 0x00, 0x00, 0x0c, 
	0x13, 0x00, 0xa2, 0xa3, 0x44, 0x00, 0x02, 0x24, 0x10, 0x00, 0xa4, 0x27, 0x08, 0x00, 0x05, 0x24, 
	0x44, 0x00, 0x06, 0x24, 0x17, 0x00, 0xa2, 0xa3, 0x00, 0x00, 0x00, 0x0c, 0x52, 0x00, 0x10, 0x24, 
	0x10, 0x00, 0xa4, 0x27, 0x0a, 0x00, 0x05, 0x24, 0x56, 0x00, 0x06, 0x24, 0x00, 0x00, 0x00, 0x0c, 
	0x19, 0x00, 0xb0, 0xa3, 0x20, 0x00, 0xa7, 0x27, 0x10, 0x00, 0xa4, 0x27, 0x21, 0x28, 0x00, 0x00, 
	0x21, 0x30, 0x00, 0x00, 0x89, 0x00, 0x00, 0x0c, 0x1b, 0x00, 0xa0, 0xa3, 0x31, 0x00, 0x02, 0x24, 
	0x10, 0x00, 0xa4, 0x27, 0x05, 0x00, 0x05, 0x24, 0x45, 0x00, 0x06, 0x24, 0x00, 0x00, 0x00, 0x0c, 
	0x13, 0x00, 0xa2, 0xa3, 0x10, 0x00, 0xa4, 0x27, 0x07, 0x00, 0x05, 0x24, 0x4f, 0x00, 0x06, 0x24, 
	0x00, 0x00, 0x00, 0x0c, 0x16, 0x00, 0xb0, 0xa3, 0x00, 0x00, 0x06, 0x3c, 0x44, 0x02, 0xc6, 0x24, 
	0x10, 0x00, 0xa4, 0x27, 0x03, 0x00, 0x00, 0x0c, 0x08, 0x00, 0x05, 0x24, 0x10, 0x00, 0xa4, 0x27, 
	0x0a, 0x00, 0x05, 0x24, 0x00, 0x00, 0x00, 0x0c, 0x52, 0x00, 0x06, 0x24, 0x10, 0x00, 0xa4, 0x27, 
	0x0c, 0x00, 0x05, 0x24, 0x21, 0x30, 0x00, 0x00, 0x56, 0x00, 0x02, 0x24, 0x00, 0x00, 0x00, 0x0c, 
	0x1b, 0x00, 0xa2, 0xa3, 0x10, 0x00, 0xa4, 0x27, 0x21, 0x28, 0x00, 0x00, 0x21, 0x30, 0x00, 0x00, 
	0x8b, 0x00, 0x00, 0x0c, 0x20, 0x00, 0xa7, 0x27, 0x17, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 
	0x80, 0xbf, 0x05, 0x3c, 0x80, 0xbf, 0x06, 0x3c, 0x90, 0xbf, 0x03, 0x3c, 0x04, 0x14, 0xa5, 0x34, 
	0x0c, 0x14, 0xc6, 0x34, 0x00, 0x08, 0x63, 0x34, 0x90, 0xbf, 0x02, 0x3c, 0x80, 0xbf, 0x04, 0x3c, 
	0x00, 0x00, 0xa2, 0xac, 0xf0, 0x10, 0x84, 0x34, 0x00, 0x00, 0xc3, 0xac, 0x00, 0x00, 0x82, 0x8c, 
	0x08, 0x00, 0x03, 0x3c, 0x25, 0x10, 0x43, 0x00, 0x80, 0xbf, 0x06, 0x3c, 0x00, 0x00, 0x82, 0xac, 
	0x70, 0x15, 0xc6, 0x34, 0x00, 0x00, 0xc2, 0x8c, 0x80, 0xbf, 0x05, 0x3c, 0x0b, 0x20, 0x03, 0x3c, 
	0x80, 0xbf, 0x04, 0x3c, 0xe1, 0x31, 0x63, 0x34, 0x08, 0x00, 0x42, 0x34, 0x14, 0x10, 0xa5, 0x34, 
	0x14, 0x14, 0x84, 0x34, 0x00, 0x00, 0xc2, 0xac, 0x00, 0x00, 0xa3, 0xac, 0x17, 0x00, 0x00, 0x08, 
	0x00, 0x00, 0x83, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0xe0, 0x41, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x6d, 0x6f, 0x64, 0x6c, 
	0x6f, 0x61, 0x64, 0x00, 0x08, 0x00, 0xe0, 0x03, 0x07, 0x00, 0x00, 0x24, 0x08, 0x00, 0xe0, 0x03, 
	0x0b, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x41, 0x44, 0x00, 0x00, 0x4d, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x2e, 0x73, 0x68, 0x73, 0x74, 0x72, 0x74, 0x61, 0x62, 0x00, 0x2e, 0x69, 0x6f, 0x70, 0x6d, 
	0x6f, 0x64, 0x00, 0x2e, 0x72, 0x65, 0x6c, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x00, 0x2e, 0x72, 0x6f, 
	0x64, 0x61, 0x74, 0x61, 0x00, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x00, 0x2e, 0x62, 0x73, 0x73, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x70, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x90, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x04, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 
	0x1d, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 
	0xd0, 0x02, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
	0x03, 0x00, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 0xe0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x2b, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 
	0xe0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x02, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0xa0, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 0x05, 0x04, 0x00, 0x00, 
	0xb0, 0x00, 0x00, 0x00, 0x06, 0x04, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 
	0xd8, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0xec, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 
	0x04, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 
	0x30, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x38, 0x01, 0x00, 0x00, 0x05, 0x04, 0x00, 0x00, 
	0x3c, 0x01, 0x00, 0x00, 0x06, 0x04, 0x00, 0x00, 0x44, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 
	0x54, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x6c, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 
	0x80, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x88, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 
	0xfc, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x02, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x07, 0x00, 0x00
};

static char s_HDDArgs[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = {
 '-', 'o', '\x00', '4',      '\x00',
 '-', 'n', '\x00', '2', '0', '\x00'
};

static char s_PFSArgs[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = {
 '-', 'm', '\x00', '4',      '\x00',
 '-', 'o', '\x00', '1', '0', '\x00',
 '-', 'n', '\x00', '4', '0', '\x00'
};

static char s_pAudSrv [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "AUDSRV";
static char s_pIOManX [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "IOMANX";
static char s_pFileXIO[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "FILEXIO";
static char s_pPS2Dev9[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "PS2DEV9";
static char s_pPS2ATAD[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "PS2ATAD";
static char s_pPS2HDD [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "PS2HDD";
static char s_pPS2FS  [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "PS2FS";
static char s_pPS2POff[] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "POWEROFF";
static char s_pUDNL   [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:UDNL rom0:EELOADCNF";
static char s_pC7     [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "\xC7\x00";
static char s_pD1     [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "\xD1\x00";
static char s_pLIBSD  [] __attribute__(   (  section( ".data" ), aligned( 1 )  )   ) = "rom0:LIBSD";

struct {

 const char* m_pName;
 void*       m_pBuffer;
 int         m_BufSize;
 int         m_nArgs;
 void*       m_pArgs;

} s_LoadParams[ 8 ] __attribute__(   (  section( ".data" )  )   ) = {
 { s_pAudSrv,  &g_DataBuffer[ SMS_AUDSRV_OFFSET   ], SMS_AUDSRV_SIZE,   0,                    NULL      },
 { s_pIOManX,  &g_DataBuffer[ SMS_IOMANX_OFFSET   ], SMS_IOMANX_SIZE,   0,                    NULL      },
 { s_pFileXIO, &g_DataBuffer[ SMS_FILEXIO_OFFSET  ], SMS_FILEXIO_SIZE,  0,                    NULL      },
 { s_pPS2POff, &g_DataBuffer[ SMS_POWEROFF_OFFSET ], SMS_POWEROFF_SIZE, 0,                    NULL      },
 { s_pPS2Dev9, &g_DataBuffer[ SMS_PS2DEV9_OFFSET  ], SMS_PS2DEV9_SIZE,  0,                    NULL      },
 { s_pPS2ATAD, &g_DataBuffer[ SMS_PS2ATAD_OFFSET  ], SMS_PS2ATAD_SIZE,  0,                    NULL      },
 { s_pPS2HDD,  &g_DataBuffer[ SMS_PS2HDD_OFFSET   ], SMS_PS2HDD_SIZE,   sizeof ( s_HDDArgs ), s_HDDArgs },
 { s_pPS2FS,   &g_DataBuffer[ SMS_PS2FS_OFFSET    ], SMS_PS2FS_SIZE,    sizeof ( s_PFSArgs ), s_PFSArgs }
};

static void ( *s_SMS_SIFCmdHandler[ 3 ] ) ( void* ) __attribute__(   (  section( ".data" )  )   );

void SMS_IOPSetSifCmdHandler (  void ( *apFunc ) ( void* ), int aCmd  ) {

 s_SMS_SIFCmdHandler[ aCmd ] = apFunc;

}  /* end SMS_SetSifCmdHandler */

static void _sif_cmd_handler ( void* apPkt, void* apArg ) {

 s_SMS_SIFCmdHandler[ (  ( SifCmdHeader_t* )apPkt  ) -> unknown ] ( apPkt );

}  /* end _sif_cmd_handler */

static void _load_module ( int anIndex ) {

 int  lRes;
 char lBuff[ 128 ]; sprintf ( lBuff, STR_LOADING.m_pStr, s_LoadParams[ anIndex ].m_pName );

 GUI_Status ( lBuff );

 SifExecModuleBuffer (
  s_LoadParams[ anIndex ].m_pBuffer, s_LoadParams[ anIndex ].m_BufSize,
  s_LoadParams[ anIndex ].m_nArgs,   s_LoadParams[ anIndex ].m_pArgs, &lRes
 );

 if ( anIndex == 4 && lRes >= 0 ) g_IOPFlags |= SMS_IOPF_DEV9;

}  /* end LoadModule */

int SMS_IOPExec ( int argc, void* argv ) {

 int lRes;

 SifExecModuleBuffer (  s_ExecIOP, sizeof ( s_ExecIOP ), argc, argv, &lRes  );

 return lRes;

}  /* end SMS_IOPExec */

void SMS_IOPReset ( int afExit ) {

 static const char* lpModules[ 4 ] = { s_pSIO2MAN, s_pPADMAN, s_pMCMAN, s_pMCSERV };

 int i;
#if 1
 SMS_IOPExec ( 1, s_pC7 );

 SifExitIopHeap (); 
 SifLoadFileExit(); 
 SifExitRpc     (); 
 SifIopReset ( s_pUDNL, 0 );

 while (  !SIF_SyncIOP ()  );

 SifInitRpc ( 0 );
#else
 afExit = 1;
#endif
 sbv_patch_enable_lmb           ();
 sbv_patch_disable_prefix_check ();

 SifExecModuleBuffer ( &g_DataBuffer[ SMS_SMSUTILS_OFFSET ], SMS_SMSUTILS_SIZE, 0, NULL, &i );

 if ( !afExit ) SifExecModuleBuffer ( &g_DataBuffer[ SMS_SIO2MAN_OFFSET  ], SMS_SIO2MAN_SIZE,  0, NULL, &i );

 for ( i = 1 - afExit; i < 4; ++i ) SifLoadModule ( lpModules[ i ], 0, NULL );

}  /* end SMS_IOPReset */

int SMS_IOPStartNet ( void ) {

 int  i;
 char lSMAPArgs[ 64 ];
 int  lSMAPALen;

 GUI_Status ( STR_INITIALIZING_NETWORK.m_pStr );

 memset (  lSMAPArgs, 0, sizeof ( lSMAPArgs )  );
 strncpy ( lSMAPArgs, g_pDefIP, 15 );
 i = strlen ( g_pDefIP ) + 1;
 strncpy ( lSMAPArgs + i, g_pDefMask, 15 );
 i += strlen ( g_pDefMask ) + 1;
 strncpy ( lSMAPArgs + i, g_pDefGW, 15 );
 i += strlen ( g_pDefGW ) + 1;
 lSMAPALen = i;

 SifExecModuleBuffer ( &g_DataBuffer[ SMS_PS2IP_OFFSET ], SMS_PS2IP_SIZE, 0, NULL, &i );

 if ( i >= 0 ) {

  SifExecModuleBuffer ( &g_DataBuffer[ SMS_PS2SMAP_OFFSET ], SMS_PS2SMAP_SIZE, lSMAPALen, &lSMAPArgs[ 0 ], &i );

  if ( i >= 0 ) {

   void* lpModule;
   int   lSize;
   int   lFlags;

   if ( g_Config.m_NetworkFlags & SMS_DF_SMB ) {
    lpModule = &g_DataBuffer[ SMS_SMB_OFFSET ];
    lSize    = SMS_SMB_SIZE;
    lFlags   = SMS_IOPF_SMB;
   } else {
    lpModule = &g_DataBuffer[ SMS_PS2HOST_OFFSET ];
    lSize    = SMS_PS2HOST_SIZE;
    lFlags   = SMS_IOPF_NET;
   }  /* end else */

   SifExecModuleBuffer ( lpModule, lSize, 0, NULL, &i );

   if ( i >= 0 ) g_IOPFlags |= lFlags;

  }  /* end if */

 }  /* end if */

 return g_IOPFlags & ( SMS_IOPF_NET | SMS_IOPF_SMB );

}  /* end SMS_IOPStartNet */

int SMS_IOPStartUSB ( void ) {

 int i;

 GUI_Status ( STR_LOCATING_USBD.m_pStr );

 SifExecModuleBuffer ( &g_DataBuffer[ SMS_USBD_OFFSET ], SMS_USBD_SIZE, 0, NULL, &i );

 if ( i >= 0 ) {

  g_IOPFlags |= SMS_IOPF_USB;
  SifExecModuleBuffer ( &g_DataBuffer[ SMS_USB_MASS_OFFSET ], SMS_USB_MASS_SIZE, 0, NULL, &i );

 }  /* end if */

 return g_IOPFlags & SMS_IOPF_USB;

}  /* end SMS_IOPStartUSB */

int SMS_IOPStartHDD ( void ) {

 if ( g_IOPFlags & SMS_IOPF_DEV9 ) {

  int i;

  for (  i = 5; i < 8; ++i  ) _load_module ( i );

  if (  !hddCheckPresent () && !hddCheckFormatted ()  ) g_IOPFlags |= SMS_IOPF_HDD;

 }  /* end if */

 return g_IOPFlags & SMS_IOPF_HDD;

}  /* end SMS_IOPStartHDD */

void SMS_IOPInit ( void ) {

 int  i, lFD;
 char lBuff[ 64 ];

 SifLoadModule ( s_pLIBSD, 0, NULL );
 SMS_IOPExec   ( 1, s_pD1 );

 lFD = fioOpen ( g_pIPConf, O_RDONLY );

 if ( lFD >= 0 ) {

  memset (  lBuff, 0, sizeof ( lBuff )  );
  i = fioRead (  lFD, lBuff, sizeof ( lBuff ) - 1  );
  fioClose ( lFD );

  if ( i > 0 ) {

   char lChr;

   lBuff[ i ] = '\x00';

   for (  i = 0; (  ( lChr = lBuff[ i ] ) != '\0'  ); ++i  )

    if (  lChr == ' ' || lChr == '\r' || lChr == '\n' ) lBuff[ i ] = '\x00';

   strncpy ( g_pDefIP, lBuff, 15 );
   i = strlen ( g_pDefIP ) + 1;
   strncpy ( g_pDefMask, lBuff + i, 15 );
   i += strlen ( g_pDefMask ) + 1;
   strncpy ( g_pDefGW, lBuff + i, 15 );

  }  /* end if */

 }  /* end if */

 for (  i = 0; i < 5; ++i  ) _load_module ( i );

 SPU_Initialize ();

 if ( g_IOPFlags & SMS_IOPF_DEV9 ) {

  if ( g_Config.m_NetworkFlags & SMS_DF_AUTO_NET ) SMS_IOPStartNet ();
  if ( g_Config.m_NetworkFlags & SMS_DF_AUTO_HDD ) SMS_IOPStartHDD ();

 }  /* end if */

 if ( g_Config.m_NetworkFlags & SMS_DF_AUTO_USB ) SMS_IOPStartUSB ();

 GUI_Status ( STR_INITIALIZING_SMS.m_pStr );

 DI();
  SifAddCmdHandler ( 18, _sif_cmd_handler, 0 );
 EI();

 hddPreparePoweroff ();

 SPU_LoadData (  g_SMSounds, sizeof ( g_SMSounds )  );

 if (  RCX_Load () && RCX_Start ()  )
  g_IOPFlags |= SMS_IOPF_RMMAN2;
 else if (  RC_Load () && RC_Start ()  ) g_IOPFlags |= SMS_IOPF_RMMAN;

 FlushCache ( 0 );

}  /* end SMS_IOPInit */
