unit Settings;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils;

type
  TForm_Settings = class(TForm)
    btn_ok:     TButton;
    btn_cancel: TButton;
    label_charset: TLabel;
    combo_charset: TComboBox;
    check_hideunused: TCheckBox;
    check_reg_dat: TCheckBox;
    check_reg_oldb: TCheckBox;
    check_reg_opf: TCheckBox;
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    function RegisterExtension(ext: String; iconindex: Integer; reg: Boolean): Integer;
  private
  public
  end;

var
  Form_Settings: TForm_Settings;

implementation

{$R *.dfm}

uses
  Main, Data, FTypeReg;



function ExtensionRegistered(ext: String; var RegisteredAs: String): Boolean;
var
  ftr: TFileTypeRegistration;
begin
  ftr := TFileTypeRegistration.Create;
  if (ftr <> nil) then
  begin
    try
      RegisteredAs := ftr.GetInternalKey(ext);
      if RegisteredAs <> '' then
        Result := True
      else
        Result := False;
    finally
      ftr.Free;
    end;
  end;
end;



function TForm_Settings.RegisterExtension(ext: String; iconindex: Integer; reg: Boolean): Integer;
var
  ftr:     TFileTypeRegistration;
  temps:   String;
  warnmsg: String;
begin
  Result := -1;
  ftr := TFileTypeRegistration.Create;
  if reg then
  begin
    if ExtensionRegistered(ext, temps) then
      if not ftr.UnregisterExtension(ext) then
        ShowMessage('Could not unregister ' + ext + '-files');
    if ftr.RegisterType(ext, 'ONI' + ext, 'ONI ' + ext + '-file', Application.EXEname, iconindex) then
    begin
      ftr.AddHandler('open', '"' + Application.EXEname + '" ' + MidStr(
        ext, 2, Length(ext) - 1) + ' "%1"');
      ftr.SetDefaultHandler;
    end;
  end else begin
    if ExtensionRegistered(ext, temps) then
      if not ftr.UnregisterExtension(ext) then
        ShowMessage('Could not unregister ' + ext + '-files');
  end;
  ftr.Free;
end;



procedure TForm_Settings.btn_cancelClick(Sender: TObject);
begin
  Self.Close;
end;



procedure TForm_Settings.btn_okClick(Sender: TObject);
var
  temps: String;
begin
  AppSettings.CharSet := StrToInt(
    MidStr(combo_charset.Items.Strings[combo_charset.ItemIndex], Pos(
    ' ', combo_charset.Items.Strings[combo_charset.ItemIndex]) + 3, Length(
    combo_charset.Items.Strings[combo_charset.ItemIndex]) - Pos(
    ' ', combo_charset.Items.Strings[combo_charset.ItemIndex]) - 2));
  AppSettings.HideUnusedData := check_hideunused.Checked;

  if check_reg_dat.Checked then
  begin
    if ExtensionRegistered('.dat', temps) then
    begin
      if temps <> 'ONI.dat' then
        if MessageBox(Self.Handle, PChar('.dat-files already registered to "' +
              temps+'". Reregister?'), PChar('Reregister?'),
              MB_YESNO + MB_ICONQUESTION) = ID_YES then
          RegisterExtension('.dat', 2, True);
    end else
      RegisterExtension('.dat', 2, True);
  end else
    RegisterExtension('.dat', 2, False);

  if check_reg_oldb.Checked then
  begin
    if ExtensionRegistered('.oldb', temps) then
    begin
      if temps <> 'ONI.oldb' then
        if MessageBox(Self.Handle, PChar('.oldb-files already registered to "' +
              temps+'". Reregister?'), PChar('Reregister?'),
              MB_YESNO + MB_ICONQUESTION) = ID_YES then
          RegisterExtension('.oldb', 1, True);
    end else
      RegisterExtension('.oldb', 1, True);
  end else
    RegisterExtension('.oldb', 1, False);

  if check_reg_opf.Checked then
  begin
    if ExtensionRegistered('.opf', temps) then
    begin
      if temps <> 'ONI.opf' then
        if MessageBox(Self.Handle, PChar('.opf-files already registered to "' +
              temps+'". Reregister?'), PChar('Reregister?'),
              MB_YESNO + MB_ICONQUESTION) = ID_YES then
          RegisterExtension('.opf', 0, True);
    end else
      RegisterExtension('.opf', 0, True);
  end else
    RegisterExtension('.opf', 0, False);

  Self.Close;
end;



procedure TForm_Settings.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose      := False;
  Self.Visible  := False;
  Form_Main.Enabled := True;
  Form_Main.SetFocus;
end;



procedure TForm_Settings.FormShow(Sender: TObject);
var
  temps: String;
  i:     Byte;
begin
  if ExtensionRegistered('.dat', temps) then
    check_reg_dat.Checked := temps = 'ONI.dat'
  else
    check_reg_dat.Checked := False;

  if ExtensionRegistered('.oldb', temps) then
    check_reg_oldb.Checked := temps = 'ONI.oldb'
  else
    check_reg_oldb.Checked := False;

  if ExtensionRegistered('.opf', temps) then
    check_reg_opf.Checked := temps = 'ONI.opf'
  else
    check_reg_opf.Checked := False;

  check_hideunused.Checked := AppSettings.HideUnusedData;

  for i := 0 to combo_charset.Items.Count - 1 do
    if StrToInt(MidStr(combo_charset.Items.Strings[i], Pos(
      ' ', combo_charset.Items.Strings[i]) + 3, Length(combo_charset.Items.Strings[i]) -
      Pos(' ', combo_charset.Items.Strings[i]) - 2)) = AppSettings.CharSet then
      combo_charset.ItemIndex := i;
end;

end.
