package net.oni2.aeinstaller.updater;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import net.oni2.ProxySettings;
import net.oni2.aeinstaller.updater.backend.Paths;
import net.oni2.aeinstaller.updater.gui.MainWin;
import net.oni2.platformtools.PlatformInformation;

/**
 * @author Christian Illy
 * @version 1
 */
public class AEInstaller2Updater {

	/**
	 * @param args
	 *            Command line arguments
	 */
	public static void main(String[] args) {
		boolean debug = false;
		for (String a : args) {
			if (a.equalsIgnoreCase("-debug"))
				debug = true;
			if (a.equalsIgnoreCase("-usewd"))
				Paths.useWorkingDirectory = true;
		}
		if (!debug) {
			try {
				PrintStream ps = new PrintStream(new FileOutputStream(new File(Paths.getPrefsPath(),
						"updater_output.log")), true);
				System.setOut(ps);
				System.setErr(ps);
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
			}
		}

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		System.out.println("Time:      " + sdf.format(new Date()));
		System.out.println("Java:      \""
				+ System.getProperty("java.runtime.name") + "\" v. "
				+ System.getProperty("java.version") + " by \""
				+ System.getProperty("java.vendor") + "\" (spec. "
				+ System.getProperty("java.specification.version") + ")");
		System.out.println("Java home: " + System.getProperty("java.home"));
		System.out.println("Command:   "
				+ System.getProperty("sun.java.command"));
		System.out.println("PrefsPath: " + Paths.getPrefsPath());
		System.out.println("DownPath:  " + Paths.getDownloadPath());
		System.out.println("TempPath:  " + Paths.getTempPath());
		System.out.println("Platform:  " + System.getProperty("os.name") +
				" detected as " + PlatformInformation.getPlatform().toString());
		System.out.println("Architect: "
				+ PlatformInformation.getArchitecture());
		System.out.println("");

		if (Paths.getProxySettingsFilename().exists()) {
			ProxySettings.deserializeFromFile(Paths.getProxySettingsFilename());
		}

		System.setProperty("networkaddress.cache.ttl", "5");
		System.setProperty("networkaddress.cache.negative.ttl", "1");

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		JFrame.setDefaultLookAndFeelDecorated(true);

		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				try {
					new MainWin().setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
}
