unit WhatLinksHere;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Template, ExtCtrls;

type
  TForm_WhatLinksHere = class(TForm)
    Panel1: TPanel;
    list_from: TListBox;
    label_what: TLabel;
    Panel2: TPanel;
    label_to: TLabel;
    list_to: TListBox;
    Splitter1: TSplitter;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure list_fromDblClick(Sender: TObject);
  private
  public
    SenderForm: TForm_ToolTemplate;
    ConID: Integer;
    FileID: Integer;
  end;

var
  Form_WhatLinksHere: TForm_WhatLinksHere;

implementation
{$R *.dfm}
uses ConnectionManager, Access_OUP_ADB, TypeDefs, Functions, Main;

{ TForm_WhatLinksHere }

procedure TForm_WhatLinksHere.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  Form_Main.Enabled := True;
  Visible := False;
  CanClose := False;
end;

procedure TForm_WhatLinksHere.FormShow(Sender: TObject);
var
  fileinfo: TFileInfo;
  links: TLinks;
  i: Integer;
  fullname: String;
  links_to: TDatLinkList;
begin
  Form_Main.Enabled := False;
  list_from.Items.Clear;
  list_to.Items.Clear;
  fileinfo := ConManager.Connection[ConID].GetFileInfo(FileID);
  label_what.Caption := FormatNumber(fileinfo.ID, 5, '0') + '-' +
      fileinfo.Name + '.' + fileinfo.Extension;
  links_to := ConManager.Connection[ConID].GetDatLinks(fileinfo.ID);
  if ConManager.Connection[ConID] is TAccess_OUP_ADB then begin
    links := TAccess_OUP_ADB(ConManager.Connection[ConID]).GetLinksToFile(fileinfo.ID);
    if Length(links.ByID) > 0 then
      for i := 0 to High(links.ByID) do
      begin
        fileinfo := ConManager.Connection[ConID].GetFileInfo(links.ByID[i].Destination);
        fullname := FormatNumber(fileinfo.ID, 5, '0') + '-' + fileinfo.Name + '.' + fileinfo.Extension;
        list_from.Items.Add(fullname + ' (Offset 0x' + IntToHex(links.ByID[i].SrcOffset, 8) + ')');
      end;
  end;
  if Length(links_to) > 0 then
  begin
    for i := 0 to High(links_to) do
    begin
      if links_to[i].DestID >= 0 then
      begin
        fileinfo := ConManager.Connection[ConID].GetFileInfo(links_to[i].DestID);
        fullname := FormatNumber(fileinfo.ID, 5, '0') + '-' + fileinfo.Name + '.' + fileinfo.Extension;
      end else
        fullname := 'no link';
      list_to.Items.Add(fullname + ' (Offset 0x' + IntToHex(links_to[i].SrcOffset, 8) + ')');
    end;
  end;
end;

procedure TForm_WhatLinksHere.list_fromDblClick(Sender: TObject);
var
  id: Integer;
  box: TListBox;
  name: String;
begin
  box := TListBox(Sender);
  name := box.Items.Strings[box.ItemIndex];
  if Pos('no link', name) > 0 then
    Exit
  else
    id := ConManager.Connection[ConID].ExtractFileIDOfName(name);
  SenderForm.SelectFileID(ConID, id);
  Form_Main.Enabled := True;
  Visible := False;
end;

end.
