@echo off

set MD5_VANILLA="7d96ffd6da21cc3f419e42f7227642fd"
set MD5_FIRST63="50374bed7f84c51bdcdcefd6300ddb84"
set MD5_LAST32="c5e46781d21cd4414e92d91502512500"

echo Welcome to the Oni 2 (Angel Studios) Layout Patch Tool.

if "%~1" == "" (
   echo You need to pass me the path to your ISO of Oni 2. Exiting.
   exit /b
)

if not exist "%~1" (
   echo Hmm, there doesn't seem to be any file at the path you passed me. Exiting.
   exit /b
)

echo Verifying checksum...

setlocal enableDelayedExpansion
set count=1
for /f "tokens=* USEBACKQ" %%L in (`CertUtil -hashfile %~1 MD5`) do (
   if !count! == 2 set MD5_INPUT=%%L
   set /a count=!count!+1
)

if not "!MD5_INPUT!" == !MD5_VANILLA! (
   if "!MD5_INPUT!" == !MD5_FIRST! (
      echo This version is already patched to enabled the first 63 layouts! You should see them in the Load Game menu.
   ) else if "!MD5_INPUT!" == !MD5_LAST32! (
      echo This version is already patched to enabled the last 32 layouts! You should see them in the Load Game menu.
   ) else (
      echo Unknown checksum! Sorry, this ISO isn't what I expected.
   )

   echo Exiting
   exit /b
)

echo You have supplied an unmodified ISO of Oni 2. Do you wish to create a patched
echo copy that enables the first 63 layouts or the last 32? Enter a number from
echo this menu:
echo ^(1^) First 63.
echo ^(2^) Last 32.
echo ^(anything else^) I changed my mind, please exit.
set /p the_answer=
if !the_answer! == 1 (
   echo Creating patched version...
   xdelta3win.exe -ds "%~1" patchFromVanTo63.xd3 oni2dev_ps2_first63layouts.iso
   echo Verifying checksum....
   set count=1
   for /f "tokens=* USEBACKQ" %%L in (`CertUtil -hashfile oni2dev_ps2_first63layouts.iso MD5`) do (
      if !count! == 2 set MD5_OUTPUT=%%L
      set /a count=!count!+1
   )
   if not "!MD5_OUTPUT!" == !MD5_FIRST63! (
      echo Uh-oh, something went wrong^! Patch failed. Exiting.
      exit /b
   )
) else if !the_answer! == 2 (
   echo Creating patched version...
   xdelta3win.exe -ds "%~1" patchFromVanTo32.xd3 oni2dev_ps2_last32layouts.iso
   echo Verifying checksum....
   set count=1
   for /f "tokens=* USEBACKQ" %%L in (`CertUtil -hashfile oni2dev_ps2_last32layouts.iso MD5`) do (
      if !count! == 2 set MD5_OUTPUT=%%L
      set /a count=!count!+1
   )
   if not "!MD5_OUTPUT!" == !MD5_LAST32! (
      echo Uh-oh, something went wrong^~ Patch failed. Exiting.
      exit /b
   )
)

echo Goodbye.
endlocal