#ifndef ONI_H
#error Do not include this file directly, include Oni/Oni.h instead!
#endif

#ifndef ONI_INPUT_H
#define ONI_INPUT_H

enum {
	LIcKey_MouseButton1 = 0x01,
	LIcKey_MouseButton2 = 0x02,
	LIcKey_MouseButton3 = 0x03,
	LIcKey_MouseButton4 = 0x04,
	LIcKey_MouseXAxis = 0x05,
	LIcKey_MouseYAxis = 0x06,
	LIcKey_MouseZAxis = 0x07,
	LIcKey_Backspace = 0x08,
	LIcKey_Tab = 0x09,
	LIcKey_Enter = 0x0d,
	LIcKey_Escape = 0x1b, /* Not in LIgInputNames */
	/* Printable ASCII characters are in here */
	LIcKey_FKey1 = 0x81,
	LIcKey_FKey2 = 0x82,
	LIcKey_FKey3 = 0x83,
	LIcKey_FKey4 = 0x84,
	LIcKey_FKey5 = 0x85,
	LIcKey_FKey6 = 0x86,
	LIcKey_FKey7 = 0x87,
	LIcKey_FKey8 = 0x88,
	LIcKey_FKey9 = 0x89,
	LIcKey_FKey10 = 0x8a,
	LIcKey_FKey11 = 0x8b,
	LIcKey_FKey12 = 0x8c,
	LIcKey_PrintScreen = 0x8d,
	LIcKey_FKey13 = 0x8d, /* Alias of LIcKey_PrintScreen */
	LIcKey_ScrollLock = 0x8e,
	LIcKey_FKey14 = 0x8e, /* Alias of LIcKey_ScrollLock */
	LIcKey_Pause = 0x8f,
	LIcKey_FKey15 = 0x8f, /* Alias of LIcKey_Pause */
	LIcKey_CapsLock = 0x90,
	LIcKey_LeftShift = 0x91,
	LIcKey_RightShift = 0x92,
	LIcKey_LeftControl = 0x93,
	/* LIgInputNames has both "leftwindows" and "leftoption" for key 0x94, but
	   nothing is mapped to 0x94 in the DirectInput and Win32 keymaps. In both
	   of them, the left Windows key is mapped to 0xc7 instead. */
	LIcKey_LeftAlt = 0x95,
	LIcKey_RightAlt = 0x96,
	/* LIgInputNames has both "rightoption" and "rightwindows" for key 0x97, but
	   nothing is mapped to 0x97 in the DirectInput and Win32 keymaps. In both
	   of them, the right Windows key is mapped to 0xc9 instead. */
	LIcKey_Apps = 0x98,
	LIcKey_RightControl = 0x99,
	LIcKey_Insert = 0xaa,
	LIcKey_Home = 0xab,
	LIcKey_PageUp = 0xac,
	LIcKey_Delete = 0xad,
	LIcKey_End = 0xae,
	LIcKey_PageDown = 0xaf,
	LIcKey_UpArrow = 0xb0,
	LIcKey_LeftArrow = 0xb1,
	LIcKey_DownArrow = 0xb2,
	LIcKey_RightArrow = 0xb3,
	LIcKey_NumLock = 0xb4,
	LIcKey_Divide = 0xb5,
	LIcKey_Multiply = 0xb6,
	LIcKey_Subtract = 0xb7,
	LIcKey_Add = 0xb8,
	LIcKey_Decimal = 0xb9,
	LIcKey_NumpadEnter = 0xba,
	LIcKey_NumpadComma = 0xbb,
	LIcKey_NumpadEquals = 0xbc,
	LIcKey_Numpad0 = 0xbd,
	LIcKey_Numpad1 = 0xbe,
	LIcKey_Numpad2 = 0xbf,
	LIcKey_Numpad3 = 0xc0,
	LIcKey_Numpad4 = 0xc1,
	LIcKey_Numpad5 = 0xc2,
	LIcKey_Numpad6 = 0xc3,
	LIcKey_Numpad7 = 0xc4,
	LIcKey_Numpad8 = 0xc5,
	LIcKey_Numpad9 = 0xc6,
	LIcKey_LeftWindows = 0xc7, /* Mapped to 0x94 in LIgInputNames */
	LIcKey_RightWindows = 0xc9, /* Mapped to 0x97 in LIgInputNames */
	LIcKey_Max,
};

enum {
	LIcActionType_None = 0,
	LIcActionType_Digital = 1,
	LIcActionType_Unknown = 2, // Unused in LIgActionDescriptions
	LIcActionType_Accumulate = 3,
	LIcActionType_Increment = 4,
	LIcActionType_Decrement = 5,
};

typedef struct {
	uint32_t input;
	float analog;
} LItDeviceInput;

typedef struct {
	uint64_t button_flags;
	float analogs[10];
} LItActionBuffer;

typedef struct {
	short type;
	short index;
	char name[32];
} LItActionDescription;

typedef struct {
	int key;
	LItActionDescription *descr;
} LItBinding;

typedef struct {
	int event;
	IMtPoint mouse_pos;
	short ch;
	/* short padding; */
	int modifiers;
} LItInputEvent;

typedef struct {
	char name[32];
	int key;
} LItInputName;

#endif
