#!/usr/bin/env bash
set -e

# This script creates a very minimal MSYS2 build environment that can be
# distributed with the Daodan source code, allowing 1-click builds with
# mingw-build.bat. It must be ran from an existing MSYS2 environment.

if [[ $(uname -o) != 'Msys' ]]; then
	printf >&2 'This script must be ran from an MSYS2 environment\n'
	exit 1
fi

cd "$(dirname -- "$0")"
root="$PWD/MSYS2"

rm -rf -- "$root"
mkdir -p -- "$root/var/lib/pacman"
pacman --noconfirm --root="$root" -Sy --needed bash
pacman --noconfirm --root="$root" -S --needed coreutils
pacman --noconfirm --root="$root" -S --needed make mingw-w64-i686-gcc
touch -- "$root/tmp/.keep"
rm -rf -- "$root/var/lib/pacman"
