unit _DataTypes;

interface

type
  TDataType = class
    private
      function GetDataLength: Integer; virtual; abstract;
      function GetValueAsString: String; virtual; abstract;
    published
      property DataLength: Integer read GetDataLength;
//      property DataLength: Integer;
      property ValueAsString: String read GetValueAsString;
  end;


  TDataField = record
    Offset: Integer;
    Data: TDataType;
  end;
  TDataFields = array of TDataField;


  TInt32 = class(TDataType)
    private
      FValue: LongWord;
      function GetDataLength: Integer; override;
      function GetValueAsString: String; override;
  end;

  TString = class(TDataType)
    private
      FString: String;
      function GetDataLength: Integer; override;
      function GetValueAsString: String; override;
  end;

implementation

uses
  SysUtils;

{ TInt32 }

function TInt32.GetDataLength: Integer;
begin
  Result := 4;
end;

function TInt32.GetValueAsString: String;
begin
  Result := IntToStr(FValue);
end;

{ TString }

function TString.GetDataLength: Integer;
begin
  Result := Length(FString);
end;

function TString.GetValueAsString: String;
begin
  Result := FString;
end;

end.
