unit _FileTypes;

interface

uses
  TypeDefs, _DataTypes;


type
  TFileType = class
    private
      FDatLinks: TDatLinkList;
      FDataFields: TDataFields;
      function GetDatLink(Offset: Integer): TDatLink;
      function GetField(Offset: Integer): TDataField;
    public
      property LinksByID[Offset: Integer]: TDatLink read GetDatLink;
      property Fields[Offset: Integer]: TDataField read GetField;
  end;


implementation

{ TFileType }

function TFileType.GetDatLink(Offset: Integer): TDatLink;
var
  i: Integer;
begin
  Result.SrcOffset := -1;
  Result.DestID := -1;
  Result.PosDestExts := '';
  
  if Length(FDatLinks) > 0 then
  begin
    for i := 0 to High(FDatLinks) do
      if FDatLinks[i].SrcOffset = Offset then
        break;
    if i < Length(FDatLinks) then
      Result := FDatLinks[i];
  end;
end;

function TFileType.GetField(Offset: Integer): TDataField;
var
  i: Integer;
begin
  Result.Offset := -1;
  Result.Data := nil;

  if Length(FDataFields) > 0 then
  begin
    for i := 0 to High(FDataFields) do
      if FDataFields[i].Offset = Offset then
        break;
    if i < Length(FDataFields) then
      Result := FDataFields[i];
  end;
end;

end.
