unit _DataTypes;

interface

type
  TDataField = class
    private
      FOffset: Integer;
      FName:   String;
      FDescription: String;
      FDataLength: Integer;
      function GetValueAsString: String; virtual; abstract;
    public
      constructor Create(Offset: Integer; Name, Description: String);

      property Offset: Integer read FOffset;
      property Name: String read FName;
      property Description: String read FDescription;
      property DataLength: Integer read FDataLength;
      property ValueAsString: String read GetValueAsString;
  end;

  TDataFields = array of TDataField;


  TInt32 = class(TDataField)
    private
      FInt: LongWord;
      function GetValueAsString: String; override;
    public
      constructor Create(Offset: Integer; Name, Description: String);
  end;


  TString = class(TDataField)
    private
      FString: String;
      function GetValueAsString: String; override;
    public
      constructor Create(Offset: Integer; Name, Description: String; Length: Integer);
  end;


  
  TArray = class(TDataField)
    private
      FDataFields: TDataFields;
      function GetFieldByOffset(Offset: Integer): TDataField;
      function GetFieldByIndex(ID: Integer): TDataField;
    public
      constructor Create(Offset: Integer; Name, Description: String; Length, Count: Integer);
      property FieldByOffset[Offset: Integer]: TDataField read GetFieldByOffset;
      property FieldByIndex[ID: Integer]: TDataField read GetFieldByIndex;
  end;

implementation

uses
  SysUtils;


{ TDataType }

constructor TDataField.Create(Offset: Integer; Name, Description: String);
begin
  FOffset := Offset;
  FName := Name;
  FDescription := Description; 
end;



{ TInt32 }

constructor TInt32.Create(Offset: Integer; Name, Description: String);
begin
  inherited Create(Offset, Name, Description);
end;

function TInt32.GetValueAsString: String;
begin
  Result := IntToStr(FInt);
end;



{ TString }

constructor TString.Create(Offset: Integer; Name, Description: String;
  Length: Integer);
begin
  inherited Create(Offset, Name, Description);

end;

function TString.GetValueAsString: String;
begin
  Result := FString;
end;



{ TArray }

constructor TArray.Create(Offset: Integer; Name, Description: String;
  Length, Count: Integer);
begin
  Exit;
end;

function TArray.GetFieldByIndex(ID: Integer): TDataField;
begin
  if ID < Length(FDataFields) then
    Result := FDataFields[ID]
  else
    Result := nil;
end;

function TArray.GetFieldByOffset(Offset: Integer): TDataField;
var
  i: Integer;
begin
  Result := nil;

  if Length(FDataFields) > 0 then
  begin
    for i := 0 to High(FDataFields) do
      if FDataFields[i].Offset = Offset then
        break;
    if i < Length(FDataFields) then
      Result := FDataFields[i];
  end;
end;


end.
