unit Img_DDSTypes;
interface

type
  TPIXELFORMAT = packed record
    Size         : Integer;
    Flags        : Integer;
    FOURCC       : array[1..4] of Char;
    RGBBitCount  : Integer;
    RBitMask     : LongWord;
    GBitMask     : LongWord;
    BBitMask     : LongWord;
    AlphaBitMask : LongWord;
  end;

  TDDSCAPS2 = packed record
    Caps1       : Integer;
    Caps2       : Integer;
    Reserved    : array[1..2] of Integer;
  end;

  TSURFACEDESC2 = packed record
    Size        : Integer;
    Flags       : Integer;
    Height      : Integer;
    Width       : Integer;
    PitchOrLinearSize : Integer;
    Depth       : Integer;
    MipMapCount : Integer;
    Reserved    : array[1..11] of Integer;
    PIXELFORMAT : TPIXELFORMAT;
    DDSCAPS2    : TDDSCAPS2;
    Reserved2   : Integer;
  end;

  TDDSDXTHeader = packed record
    FOURCC       : array[1..4] of Char;
    SURFACEDESC2 : TSURFACEDESC2;
  end;

const
  DDSD_CAPS : Integer = $00000001;
  DDSD_HEIGHT : Integer = $00000002;
  DDSD_WIDTH : Integer = $00000004;
  DDSD_PITCH : Integer = $00000008;
  DDSD_PIXELFORMAT : Integer = $00001000;
  DDSD_MIPMAPCOUNT : Integer = $00020000;
  DDSD_LINEARSIZE : Integer = $00080000;
  DDSD_DEPTH : Integer = $00800000;

  DDPF_ALPHAPIXELS : Integer = $00000001;
  DDPF_FOURCC : Integer = $00000004;
  DDPF_RGB : Integer = $00000040;

  DDSCAPS_COMPLEX : Integer = $00000008;
  DDSCAPS_TEXTURE : Integer = $00001000;
  DDSCAPS_MIPMAP : Integer = $00400000;

  DDSCAPS2_CUBEMAP : Integer = $00000200;
  DDSCAPS2_CUBEMAP_POSITIVEX : Integer = $00000400;
  DDSCAPS2_CUBEMAP_NEGATIVEX : Integer = $00000800;
  DDSCAPS2_CUBEMAP_POSITIVEY : Integer = $00001000;
  DDSCAPS2_CUBEMAP_NEGATIVEY : Integer = $00002000;
  DDSCAPS2_CUBEMAP_POSITIVEZ : Integer = $00004000;
  DDSCAPS2_CUBEMAP_NEGATIVEZ : Integer = $00008000;
  DDSCAPS2_VOLUME : Integer = $00200000;

implementation
end.
