#################
### VARIABLES ###
#################

var int var_counter = 0;

############
### MAIN ###
############

func void main(void)
{
gl_fog_red = .30
gl_fog_blue = .15
gl_fog_green = .17
gl_fog_start = .995
gs_farclipplane_set 5000
ui_suppress_prompt = 1
chr_auto_aim_dist = 0
start
}

#############
### START ###
#############

func void start(string ai_name)
{
if(save_point eq 0) save_point = 1 
if(save_point eq 1) fork intro
if (save_point eq 2) restore_game
if (save_point eq 3) restore_game
sleep 5
fork sp_all
}

func void deactivate_stuff(void)
{
#not used
trigvolume_enable floor1 0
trigvolume_enable save_1_trig 0
trigvolume_enable save_3_trig 0
trigvolume_enable sapperdamageon 0
trigvolume_enable trigger_volume_36 0
trigvolume_enable trigger_volume_36_copy 0
trigvolume_enable trigger_volume_36_copy_copy 0
#used
trigvolume_enable outro_volume_1 0
trigvolume_enable attack_trigger 0
trigvolume_enable final_ambush 0
env_show 776 0
env_show 777 0
obj_create 2 7
}

func void you_lose(string ai_name)
{
fade_out 0 0 0 30
sleep 30
lose
}

####################################
### SEVERAL TIMES USED FUNCTIONS ###
####################################

func void sp_all(void)
{
co_message_display = 0
if(save_point eq 1) save_game 1 autosave
if(save_point eq 2) save_game 2 autosave
if(save_point eq 3) save_game 3 autosave
sleep 180
co_message_display = 1
}

func void remove_ai(void)
{
ai2_kill
sleep 60
powerup_reset
weapon_reset
sleep 240
corpse_reset
}

func void music_stop(void)
{
sound_music_stop mus_main01_hd
sound_music_stop mus_main03
}

##########
### SP1 ###
##########

func void intro(void)
{
ai2_spawn Barabus
ai2_attack Barabus konoko
playback 0 IntroKonoko01
chr_inv_reset 0
env_show 8 1
env_show 9 1
env_show 10 1
objective_set 1 silent
sleep 1
sound_music_start mus_main01_hd 0.8
}

#tv31 - at the place, where Konoko gets off the bike (inside func: save_game_1); I've disabled it

#lose func of Barabus
func void rocket(void)
{
music_stop
chr_animate Barabus STRIKEknockdown1
fade_out 0 0 0 30
sleep 30
chr_animate_block Barabus BARABlev3_rocket
chr_envanim Barabus RocketBox01
sound_ambient_start c01_00_02barjet
particle lock99_locklight01 do start
door_unlock 43
objective_set 2 silent
target_set 143 30
fade_in 30
sleep 360
chr_delete Barabus
sleep 600
sound_dialog_play c00_01_98shinatama
}

#tv22 - if you look to the gate, on the left, around the place where you find the plasma gun
func void spawn_right_patrol(string ai_name)
{
ai2_spawn right_patrol_striker_1
}

#tv23 - between the last pillar and the 5 glass doors
func void spawn_back_patrol(string ai_name)
{
ai2_spawn back_patrol_striker_1
ai2_spawn back_patrol_striker_2
}

#tv21 - if you look to the gate, on the right, nearly at the end of the way
func void spawn_left_patrol(string ai_name)
{
ai2_spawn left_patrol_striker_1
}

#tv8 - in front of door 43 (func: spawn_floor1_guards); I've disabled it

##########
### SP2 ###
##########

### GROUND FLOOR ###

#tv33 - after door 43
func void turnoffcompass(string ai_name)
{
if(save_point ne 2)
	{
	save_game 2 autosave	
	target_set 143 0
	}
ai2_spawn Floor1_Striker_1
ai2_spawn Floor1_Striker_2
ai2_spawn Floor1_Sci_1
ai2_spawn Floor1_Sci_2
ai2_spawn Floor1_Sci_3
ai2_spawn Floor1_Sci_4
objective_set 3 silent
tr_write_animation KONCOMpunch_heavy tramph.txt
}

#tv35 - complete room with console 2 (no funcs); I've disabled it

#console 2
func void unlock_floor1_doors(string ai_name)
{
particle lock1_locklight01 do start
particle lock4a_locklight01 do start
door_unlock 3
door_unlock 8
door_unlock 11
door_unlock 14
door_unlock 17
door_unlock 20
door_unlock 23
door_unlock 26
check_doors
}

#tv3 - long box in some distance after door 3, door 14, door 20 and door 26
func void spawn_floor1_striker_11(string ai_name)
{
ai2_spawn Floor1_Striker_11
ai2_spawn Floor1_Striker_12
}

#tv4 - long box in some distance after door 8, door 11, door 17 and door 23
func void spawn_floor1_striker_10(string ai_name)
{
ai2_spawn Floor1_Striker_10
ai2_spawn Floor1_Striker_12
}

#tv1 - in front of the stairs
func void spawn_floor2_guards(string ai_name)
{
ai2_spawn Floor2_Striker_2
ai2_spawn Floor2_Striker_3
ai2_spawn Floor2_Striker_4
sleep 15
ai2_spawn Floor2_Striker_1
ai2_doalarm Floor2_Striker_1 3
sleep 15
ai2_spawn Floor2_Sci_1
ai2_spawn Floor2_Sci_2
ai2_spawn Floor2_Sci_3
ai2_spawn Floor2_Sci_4
ai2_spawn Floor2_Sci_5
}

#tv10 - on the platform between the ground floor and the first floor
func void set_target_4(string chr_index)
{
sound_dialog_play c00_01_26shinatama
target_set 253 30
}

### FIRST FLOOR ###

#tv36 - complete room with console 3 (no funcs); I've disabled it

#console 3
func void unlock_floor2_doors(void)
{
trigvolume_enable attack_trigger 1
particle lock2_locklight01 do start
particle lock4b_locklight01 do start
door_unlock 2
door_unlock 9
door_unlock 12
door_unlock 15
door_unlock 18
door_unlock 21
door_unlock 24
door_unlock 27
check_doors
sleep 60
ai2_dopath Floor2_Striker_1 Floor2_Stk_1
ai2_setjobstate Floor2_Striker_1
}

#tv24 - after door 6; outside of the room with console 3 (tv name: attack_trigger)
func void commence_attack(string ai_name)
{
ai2_setalert Floor2_Striker_2 high
ai2_setalert Floor2_Striker_3 high
ai2_setalert Floor2_Striker_4 high
ai2_dopath Floor2_Striker_1 Floor2_Stk_1
ai2_dopath Floor2_Striker_2 scram_path
ai2_dopath Floor2_Striker_3 attack_path_1
ai2_dopath Floor2_Striker_4 attack_path_2
ai2_setjobstate Floor2_Striker_1
ai2_setjobstate Floor2_Striker_2
ai2_setjobstate Floor2_Striker_3
ai2_setjobstate Floor2_Striker_4
ai2_attack Floor2_Striker_4 Floor2_Sci_4
ai2_attack Floor2_Striker_3 Floor2_Sci_1
}

#lose func of Floor2_Sci_4
func void death_sentence_1(string ai_name)
{
ai2_attack Floor2_Striker_4 Floor2_Sci_5
}

#lose func of Floor2_Sci_1
func void death_sentence_2(string ai_name)
{
ai2_attack Floor2_Striker_3 Floor2_Sci_2
}

#lose func of Floor2_Sci_2
func void death_sentence_3(string ai_name)
{
ai2_attack Floor2_Striker_3 Floor2_Sci_3
}

#tv2 - in front of the stairs
func void spawn_floor3_guards(string ai_name)
{
ai2_spawn Floor3_Striker_1
ai2_spawn Floor3_Striker_2
ai2_spawn Floor3_Striker_3
ai2_spawn Floor3_Comguy_1
}

#tv11 - on the platform between the first and the second floor
func void set_target_5(string chr_index)
{
sound_dialog_play c00_01_28shinatama
target_set 254 30
}

### SECOND FLOOR ###

#tv37 - complete room with console 4 (no funcs); I've disabled it

#console 4
func void unlock_floor3_doors(string ai_name)
{
particle lock3_locklight01 do start
particle lock4c_locklight01 do start
door_unlock 1
door_unlock 10
door_unlock 13
door_unlock 16
door_unlock 19
door_unlock 22
door_unlock 25
door_unlock 28
check_doors
}

### ROOF ###

#tv12 - in front of door 4
func void set_objective_4(string chr_index)
{
sound_dialog_play c00_01_19shinatama
objective_set 4 silent
target_set 110 30
}

#tv30 - in some distance after the ramp to the lower roof; box from left to right
func void roof_surprise(string ai_name)
{
ai2_dopath Roof_Striker_3 Roof_Striker_3b
ai2_setjobstate Roof_Striker_3
}

#tv5 - after door 39
func void spawn_tower_guards(string ai_name)
{
ai2_spawn Tower_Striker_1
ai2_spawn Tower_Striker_2
}

#tv18 - after door 41; on the right side
func void tower_lock_1(string chr_index)
{
ai2_spawn Tower_MB_1
particle sapper do start
music_stop
}

#tv17 - right next to the furniture in the middle of the tower; from left to right (entry func: sapper_damage_on); I've disabled it

#lose func of Tower_MB_1
func void bomber(void)
{
fade_out 0 0 0 30
sleep 30
chr_delete Tower_MB_1
fork remove_ai
particle sapper do stop
chr_teleport 0 99
chr_facetoflag 0 90
fade_in 30
}

##########
### SP3 ###
##########

### LOBBY - GROUND FLOOR ###

#tv9 - in front of door 35; in the elevator shaft
func void spawn_lobby_tctf(string ai_name)
{
if(save_point ne 3)
	{
	sleep 30
	save_game 3 autosave
	}
env_show 540 0
env_show 777 1
env_show 778 0
ai2_spawn Lobby_TCL_1
ai2_spawn Lobby_TCL_2
ai2_spawn Lobby_TCS_1
objective_set 5 silent
target_set 142 30
}

#tv34 - after door 35 (inside func: save_game_3); I've disabled it

#tv13 - big box from door 59 and door 60 to the opposite wall; includes console 1
func void spawn_lobby_synd(string ai_name)
{
ai2_spawn Lobby_Striker_1
ai2_spawn Lobby_Striker_2
ai2_spawn Lobby_Striker_3
ai2_spawn Lobby_Striker_4
}

#hit func of Lobby_TCL_1
func void Lobby_Hurt_TCL_1(string ai_name)
{
ai2_dopath Lobby_TCL_1 Lobby_Hurt_TCL_1
}

#hit func of Lobby_TCL_2
func void Lobby_Hurt_TCL_2(string ai_name)
{
sleep 120
ai2_dopath Lobby_TCL_2 Lobby_Hurt_TCL_2
}

#tv32 - at the end of the stairs to the lower floor with console 11; big box from left to right
func void backdoor(string ai_name)
{
ai2_spawn backdoor_striker_1
ai2_spawn backdoor_striker_3
}

#console 11
func void passage_1(string ai_name)
{
particle lock69a_locklight01 do start
check_doors
}

### LOBBY - FIRST FLOOR ###

#tv28 - long box; starts in some after door 53 and ends in front of console 9
func void spawn_lively_2(string ai_name)
{
ai2_spawn lively_striker_2
}

#console 9
func void passage_2(string ai_name)
{
particle lock69b_locklight01 do start
check_doors
}

#tv26 - in some distance after door 37
func void spawn_opposite_striker_1(string ai_name)
{
ai2_spawn opposite_striker_1
}

#tv27 - in some distance after door 31
func void spawn_opposite_striker_2(string ai_name)
{
ai2_spawn opposite_striker_2
}

### LOBBY - SECOND FLOOR ###

#tv25 - around the green energy clip; in the room with door 46
func void spawn_lively_1(string ai_name)
{
ai2_spawn lively_striker_1
}

#tv29 - at the end of the room with door 29; from left to right; includes the hypo
func void spawn_lively_3(string ai_name)
{
ai2_spawn lively_striker_3
ai2_spawn lively_striker_4
}

#console 8
func void passage_3(string ai_name)
{
particle lock69c_locklight01 do start
check_doors
}

func void check_doors(void)
{
var_counter = var_counter + 1
if(var_counter eq 3)
	{
	if(save_point eq 2)
		{
		door_unlock 4
		ai2_spawn Roof_Striker_1
		ai2_spawn Roof_Striker_2
		ai2_spawn Roof_Striker_3
		sound_music_start mus_main03
		}
	if(save_point eq 3)
		{
		door_unlock 48
		sound_music_start mus_main03 1.0
		}
	var_counter = 0
	}
}

#tv20 - in front of door 48
func void miseenscene_start(string ai_name)
{
particle scene create
ai2_spawn scene_thug_1
ai2_spawn scene_thug_2
}

#tv6 - in the middle between door 48 and door 55
func void spawn_vats(string ai_name)
{
ai2_spawn Vat_Striker_1
ai2_spawn Vat_Striker_2
ai2_spawn Vat_Striker_3
ai2_spawn Vat_Striker_4
ai2_spawn Vat_Striker_5
}

#console 10 (text console)
func void day_264(string ai_name)
{
ai2_idle scene_thug_1
ai2_movetoflag scene_thug_1 7010
ai2_setmovementmode scene_thug_1 run
sleep 300
particle day264 create
particle dayafter create
particle dayafter do start
chr_animate scene_thug_1 STRIKEknockdown3
ai2_dopath scene_thug_1 scene_flee_1
ai2_dopath scene_thug_2 scene_flee_2
sleep 300
ai2_spawn arcy
sleep 1000
chr_delete scene_thug_1
chr_delete scene_thug_2
sleep 500
chr_delete arcy
}

#tv19 - in front of door 55
func void set_objective_6(string chr_index)
{
sound_dialog_play c00_01_22shinatama
objective_set 6 silent
target_set 256 30
}

### HALL ###

#tv16 - the complete acid volume
func void fallinthevat(string character)
{
if(chr_is_player(character) eq 1)
	{
  	cm_detach
    	chr_animate 0 KONOKOacid
	sleep 10
	sound_impulse_play konoko_gruesome_death
	chr_set_health 0 0
	}
else
	{
	chr_animate(character, KONOKOacid);
	sleep 10
	chr_set_health(character, 0);
  	}
}

#console 5
func void unlock_end_door(string ai_name)
{
trigvolume_enable final_ambush 1
particle lockend_locklight02 do start
door_unlock 56
target_set 52 30
ai2_spawn Vat_MB_1
}

#tv7 - in some distance in front three pillars; from left to right
func void final_ambush(string ai_name)
{
ai2_spawn Ambush_Striker_1
ai2_spawn Ambush_Striker_2
}

#hit func of Ambush_Striker_1
func void gethelp(string ai_name)
{
trigvolume_enable outro_volume_1 1
particle lock177_locklight01 do start
door_unlock 49
door_unlock 50
ai2_attack Ambush_Striker_2 Konoko
music_stop
}

#tv14 - after door 50
#tv15 - after door 49
func void outro(void)
{
fade_out 0 0 0 30
sleep 30
win
}

#####################
### TEXT CONSOLES ###
#####################

func void level3a(string chr_index)
{
text_console level_3a
console_reset 7
}

func void level3b(string chr_index)
{
text_console level_3b
console_reset 6
}

func void level3c(string chr_index)
{
text_console level_3c
console_reset 1
}

func void level3d(string chr_index)
{
text_console level_3d
day_264
}