#!/bin/sh
cd dat/original
if [ ! -e ../../../GameDataFolder ]
then
    echo "Can't find GameDataFolder!"
    echo "Make sure this is Oni/nikanabo"
else
    echo "GameDataFolder detected!"
    if [ -e backupok.txt ]
    then
        echo "Game content already backed up."
    else
        echo "Backing up game content..."
        cp ../../../GameDataFolder/*.dat .
        cp ../../../GameDataFolder/*.raw .
        cp ../../../GameDataFolder/*.sep .
        echo "Game content backup complete."
        mv nobackup.txt backupok.txt
    fi
fi
cd ../..
cd bsl/mybackup
if [ ! -e ../../../GameDataFolder/IGMD ]
then
    echo "Can't find IGMD folder!"
    echo "Make sure this is Oni/nikanabo"
else
    echo "IGMD folder detected!"
    if [ -e backupok.txt ]
    then
        echo "Level logic already backed up."
    else
        echo "Backing up level logic..."
        cp -r ../../../GameDataFolder/IGMD IGMD
        echo "Level logic backup complete."
        mv nobackup.txt backupok.txt
    fi
fi
cd ../..
