#################
### VARIABLES ###
#################

var int var_counter = 0;

############
### MAIN ###
############

func void main(void)
{
gl_fog_red = .15
gl_fog_blue = .15
gl_fog_green = .15
gl_fog_start = .995
gs_farclipplane_set 5000
ui_suppress_prompt = 1
chr_auto_aim_dist = 0
if(save_point > 0) start
}

#############
### START ###
#############

func void start(string ai_name)
{
fork deactivate_stuff
splash_screen warehouse_splash_screen
if(save_point eq 1) save_point = 2
if(save_point eq 2) fork intro
if(save_point eq 3) restore_game
if(save_point eq 4) restore_game
if(save_point eq 5) restore_game
sleep 5
fork sp_all
}

func void deactivate_stuff(void)
{
#not used
trigvolume_enable tv_train_movement 0
console_deactivate 4
trigvolume_enable alarm_trigvol 0
trigvolume_enable mid_warehouse_target 0
trigvolume_enable setup_bay3_tv 0
trigvolume_enable trigger_volume_01 0
trigvolume_enable trigger_volume_06 0
trigvolume_enable trigger_volume_63 0
trigvolume_enable trigger_volume_64 0
trigvolume_enable trigger_volume_65 0
trigvolume_enable trigger_volume_68 0
trigvolume_enable trigger_volume_70 0
trigvolume_enable trigger_volume_76 0
trigvolume_enable trigger_volume_77 0
trigvolume_enable trigger_volume_80 0
trigvolume_enable tv_66 0
#used
door_unlock 108
env_show 2010 0
obj_create 20 20
trigvolume_enable gotLSI_tv 0
}

func void you_lose(string ai_name)
{
fade_out 0 0 0 30
sleep 30
lose
}

####################################
### SEVERAL TIMES USED FUNCTIONS ###
####################################

func void sp_all(void)
{
co_message_display = 0
if(save_point eq 2) save_game 2 autosave
if(save_point eq 3) save_game 3 autosave
if(save_point eq 4) save_game 4 autosave
if(save_point eq 5) save_game 5 autosave
sleep 180
co_message_display = 1
}

func void remove_ai(void)
{
ai2_kill
sleep 60
powerup_reset
weapon_reset
sleep 240
corpse_reset
}

func void music_stop(void)
{
#training
sound_music_stop atm_gr06
sound_music_stop atm_ft68
#warehoue
sound_music_volume mus_ambgrv1 0.0 2.0
sound_music_stop mus_ambgrv1
sound_music_stop atm_low1
sound_music_volume mus_chase 0.0 3.0
sound_music_stop mus_chase
}

##########
### SP1 ###
##########

func void intro(void)
{
playback 0 SwingKonokoSet
chr_inv_reset 0
ai2_spawn A_t48
objective_set 1 silent
}

#tv55 - the complete area of the platform where Konoko starts (no funcs); I've disabled it
#lose func of A_t48 (func: t48_dead); I don't use it

#console 1
func void unlock6(string ai_name)
{
particle d1_locklight01 do start
door_unlock 6
target_set 44 30
ai2_spawn A_t50
trigvolume_enable trigger_volume_65 1
}

#tv57 - in front of door 6 (entry func: t65; exit func: t65b); I've diabled it

### FIRST HALL - GROUND FLOOR ###

#tv56 - after door 6 (entry func: t64); I've diabled it
#tv72 - right side; in the right corner (entry func: t77); I've diabled it

#tv12 - left side; after the box near the left wall
func void rat3(void)
{
particle rat3 pulse
}

#tv11 - in front of door 16; right side; around the small drum
func void bug0(void)
{
particle bug0 pulse
}

### FIRST HALL - FIRST FLOOR ###

#console 2
func void unlock1(string ai_name)
{
particle lock1_locklight01 do start
door_unlock 15
door_unlock 16
target_set 33 15
sleep 120
ai2_spawn Bay1_Thug_1
}

### FIRST HALL - SECOND FLOOR ###

#tv74 - on the top of the crane cabin
func void t02(string ai_name)
{
ai2_spawn secret2
ai2_dopath A_t50 patrol_secret1
ai2_setjobstate A_t50
fork health_check
}

func void health_check(void)
{
chr_wait_health secret2 0
train_fathealth
}

#tv58 - in front of door 4 (entry func: t01); I've disabled it

### SECOND HALL - GROUND FLOOR ###

#tv80 - the complete volume of the hall (no funcs); I've disabled it

#tv1 - high box after door 16 and door 15
func void intro_enemies(string ai_name)
{
ai2_spawn Bay2_Thug_1
ai2_spawn Bay2_Thug_2
sound_music_start mus_ambgrv1 0
sound_music_volume mus_ambgrv1 0.75 3.0
}

#lose func of Bay2_Thug_1
func void train_fathealth(string ai_name)
{
if(var_counter eq 0)
	{
	var_counter = 1
	sleep 90
	sound_dialog_play c00_01_93shinatama
	sound_dialog_play_block pause
	sleep 40
	sound_dialog_play c00_01_94shinatama
	}
}

#tv19 - after one third of the hall; from left to right; ends right in some distance in front of door 18
func void rat1(void)
{
particle rat1 pulse
}

#tv13 - after door 18
func void bug8(void)
{
particle bug8 pulse
}

#console 3
func void unlock2(string ai_name)
{
particle lock2_locklight01 do start
door_unlock 24
door_unlock 26
target_set 84 15
music_stop
}

#tv4 - in front of door 26 and door 24 (entry func: setup_bay3); I've disabled it

### SECOND HALL - FIRST FLOOR ###

#nothing here; no second floor

### THIRD HALL - GROUND FLOOR ###

#tv15 - after door 26; right side; in front of the first box
func void rat6(void)
{
particle rat6 pulse
}

#tv14 - next to tv15; in front of the second box
func void bug4(void)
{
particle bug4 pulse
}

#tv16 - in some distance after door 31
func void rat4(void)
{
particle rat4 pulse
}

### THIRD HALL - FIRST FLOOR ###

#tv5 - around Chung
func void Chung(void)
{
sound_music_start atm_low1 0.7
trigvolume_enable gotLSI_tv 1
target_set 1 0
}

#tv30 - around the lsi
func void checkLSI(string ai_name)
{
trigvolume_enable gotLSI_tv 0
if(chr_has_lsi(0) eq 1)
	{
	particle lock3_locklight01 do start
	door_unlock 37
	music_stop
	ai2_spawn Ambush_Striker_1
	ai2_spawn Mid_Thug_1
	ai2_spawn Mid_Thug_2
	objective_set 2 silent
	target_set 7053 30
	var_counter = 0
	}
if(chr_has_lsi(0) eq 0)
	{
	sleep 60
	trigvolume_enable gotLSI_tv 1
	}
}

### THIRD HALL - SECOND FLOOR ###

#tv75 - in front of door 32
func void t05(string ai_name)
{
ai2_spawn ambush_striker
}

##########
### SP2 ###
##########

#tv59 - after door 37
func void s2(string player_name)
{
if(save_point eq 3)
	{
	ai2_spawn Mid_Thug_1
	ai2_spawn Mid_Thug_2
	objective_set 2 silent
	target_set 7053 30
	}
else save_game 3 autosave
}

#tv76 - in front of door 36
func void t09(string ai_name)
{
target_set 62 30
}

#tv63 - after door 35
func void t07(string ai_name)
{
ai2_spawn Top_Thug_5
}

#tv64 - after door 34; near the end of the way; near the corner of the left wall
func void t69(string ai_name)
{
ai2_spawn Top_Striker_1
ai2_spawn Top_Comguy_1
ai2_spawn Top_Thug_3
}

#tv6 - in front of door 61
func void spawn_mid2(string ai_name)
{
ai2_spawn Mid2_Striker_1
ai2_spawn Mid2_Striker_2
target_set 66 15
}

#console 5
func void unlock4(string ai_name)
{
particle lock4_locklight01 do start
door_unlock 65
target_set 7054 15
}

##########
### SP3 ###
##########

#tv62 - after door 65 (entry func: s3); I've disabled it

#tv2 - after door 65; nearly at the same position as tv62
func void train_alarm(string ai_name)
{
if(save_point eq 4)
	{
	objective_set 2 silent
	target_set 7054 15
	}
else
	{
	fork remove_ai
	save_game 4 autosave
	door_lock 60
	}
ai2_spawn Bay4_Comguy_1
}

### FIRST HALL - GROUND FLOOR ###

#tv18 - in front of door 68
func void rat5(void)
{
particle rat5 pulse
}

#console 7 ==> see second floor

### FIRST HALL - FIRST FLOOR ###

#hit func of Bay4_Comguy_1
func void hurt1(string ai_name)
{
ai2_makeignoreplayer Bay4_Comguy_1 1
ai2_doalarm Bay4_Comguy_1 6
ai2_dopath Bay4_Comguy_1 Run_To_Alarm
ai2_setjobstate Bay4_Comguy_1
sleep 60
sound_dialog_play c00_01_96shinatama
}

func void patrolscript0001(string ai_name)
{
ai2_doalarm Bay4_Comguy_1 6
}

### FIRST HALL - SECOND FLOOR ###

#console 7
func void unlock5(string ai_name)
{
particle lock4_locklight01 do stop
door_lock 65
particle lock5_locklight01 do start
door_unlock 73
door_unlock 74
door_unlock 81
door_unlock 82
target_set 72 30
console_deactivate 7
var_counter = 1
}

#tv7 - in front of console 6 (entry func: alarm_warning; exit func: alarm_warningb); I've disabled it

#console 6
func void alarm_trig(string ai_name)
{
fork do_alarm_sound
if(var_counter eq 0) unlock5
ai2_makeignoreplayer Bay4_Comguy_1 0
ai2_dopath Bay4_Comguy_1 patrol_42
ai2_setjobstate Bay4_Comguy_1 
ai2_spawn Alarm_Bay4_Striker_1
chr_teleport Alarm_Bay4_Striker_1 7033
ai2_attack Alarm_Bay4_Striker_1 char_0
ai2_spawn Alarm_Bay4_Striker_2
chr_teleport Alarm_Bay4_Striker_2 7033
ai2_attack Alarm_Bay4_Striker_2 char_0
}

func void do_alarm_sound(void)
{
sound_ambient_start alarm_loop
sleep 900
sound_ambient_stop alarm_loop
}

#console 4 (func: unlock_alarm); I've disabled it

### SECOND HALL - GROUND FLOOR ###

#tv31 - high box after door 73 and door 74
func void t47(string ai_name)
{
ai2_spawn Bay5_Thug_1
ai2_spawn Bay5_Thug_2
}

### SECOND HALL - FIRST FLOOR ###

#nothing, no second floor

### THIRD HALL - GROUND FLOOR ###

#tv32 - after door 81
func void spawn_bay6_bot(string ai_name)
{
trigvolume_enable spawn_bay6_top_tv 0
ai2_spawn Bay6_Striker_1b
ai2_spawn Bay6_Neutral_1b
ai2_spawn Bay6_Neutral_2
ai2_spawn guard1
train_neutral
}

func void train_neutral(string ai_name)
{
target_set 92 15
sound_dialog_play c00_01_97shinatama
}

### THIRD HALL - FIRST FLOOR ###

#tv60 - complete volume of the first floor (no funcs); I've disabled it

#tv3 - after door 82
func void spawn_bay6_top(string ai_name)
{
trigvolume_enable spawn_bay6_bot_tv 0
ai2_spawn Bay6_Striker_1
ai2_spawn Bay6_Neutral_1
ai2_spawn Bay6_Neutral_2
ai2_spawn guard1
train_neutral
}

#tv79 - after door 87
func void t10(string ai_name)
{
ai2_makeignoreplayer Bay6_Neutral_1 1
ai2_makeignoreplayer Bay6_Neutral_1b 1
ai2_dopath Bay6_Neutral_1 Bay6_Thug_1
ai2_dopath Bay6_Neutral_1b Bay6_Thug_1_copy
sleep 240
ai2_makeignoreplayer Bay6_Neutral_1 0
ai2_makeignoreplayer Bay6_Neutral_1b 0	
}

### THIRD HALL - SECOND FLOOR ###

#tv61 - after door 88
func void t67(string ai_name)
{
chr_changeteam guard1 Syndicate
}

#neutral func of Bay6_Neutral_2
func void gotoconsole(string ai_name)
{
console_activate 9
sleep 7
ai2_doalarm Bay6_Neutral_2 9
sleep 180
trigvolume_enable trigger_volume_06 1
}

#tv77 - around console 9 (exit func: t06); I've disabled it

#console 9
func void open_warehouse(string ai_name)
{
if(save_point eq 4)
	{
	particle lock7_locklight01 do start
	door_unlock 86
	ai2_spawn Final_Thug_1
	ai2_spawn Final_Thug_2
	ai2_spawn Final_Thug_3
	ai2_spawn Final_Thug_5
	ai2_dopath Bay6_Neutral_2 Open_Warehouse
	ai2_setjobstate Bay6_Neutral_2
	objective_set 3 silent
	target_set 93 15
	}
particle bigdoor_locklight02 do start
ai2_spawn WH_Thug_A
ai2_dopath WH_Thug_A WH_Thug_A
ai2_setjobstate WH_Thug_A
ai2_spawn WH_Striker_B
ai2_dopath WH_Striker_B WH_Striker_B
ai2_setjobstate WH_Striker_B
ai2_spawn WH_Striker_C
ai2_spawn WH_Striker_D
ai2_dopath WH_Striker_D WH_Striker_D
ai2_setjobstate WH_Striker_D
}

#tv8 - in front of door 48 (entry func: train_timer); I've diabled it

##########
### SP4 ###
##########

#tv73 - after door 48
func void s4(string ai_name)
{
if(save_point eq 5) open_warehouse
else save_game 5 autosave
objective_set 4 silent
target_set 96 15
sleep 1
timer_start 180 you_lose
sound_music_start mus_chase 0
sound_music_volume mus_chase 0.50 1.0
sound_dialog_play c00_01_95shinatama
sound_dialog_play_block pause
sound_music_volume mus_chase 0.75 1.0
}

#tv17 - after door 48; right next to the box at 10 past 12
func void rat2(void)
{
particle rat2 pulse
}

#tv9 - after door 56
func void stair1_target(string ai_name)
{
target_set 31 15
}

#tv10 - in front of door 58
func void stair2_target(string ai_name)
{
target_set 81 15
}

#tv71 - big box around console 8 (no funcs); I've disabld it
#tv65 - not so big box around console 8 (inside func: t70); I've disabld it

#lose func of WH_Striker_C
func void end_striker(string ai_name)
{
music_stop
}

#console 8
func void end_console(string ai_name)
{
timer_stop
fade_out 0 0 0 30
sleep 30
win
}

#####################
### TEXT CONSOLES ###
#####################

func void console_evidence1(string ai_name)
{
text_console level_1a
console_reset 19
}

func void console_evidence2(string ai_name)
{
text_console level_1b
console_reset 20
}
