unit TxmpReplace;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Template, StdCtrls, ExtCtrls,
  Functions, Data, OniImgClass, Menus, Buttons, TypeDefs;

type
  TForm_TxmpReplace = class(TForm_ToolTemplate)
    group_options: TGroupBox;
    btn_replace: TButton;
    check_transparency: TCheckBox;
    check_fading: TCheckBox;
    panel_txmppreview: TPanel;
    btn_save: TButton;
    image_txmppreview: TImage;
    splitter_txmp: TSplitter;
    group_bmpselect: TGroupBox;
    image_bmppreview: TImage;
    panel_load: TPanel;
    btn_load: TButton;
    opend: TOpenDialog;
    saved: TSaveDialog;
    procedure SelectFile(fileinfo: TFileInfo);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btn_saveClick(Sender: TObject);
    procedure btn_loadClick(Sender: TObject);
    procedure btn_replaceClick(Sender: TObject);
    procedure Splitter1Moved(Sender: TObject);
  private
    OniImage_Old: TOniImage;
    OniImage_New: TOniImage;
    old_size: Integer;
    fileid: Integer;
  public
  end;

var
  Form_TxmpReplace: TForm_TxmpReplace;

implementation
{$R *.dfm}
uses Main, ConnectionManager, ImagingTypes;



procedure TForm_TxmpReplace.SelectFile(fileinfo: TFileInfo);
var
  mem:  TMemoryStream;
  fadingbyte, depthbyte, storebyte: Byte;
begin
  fileid := fileinfo.ID;
  ConManager.Connection[ConnectionID].LoadDatFilePart(fileid, $88, SizeOf(fadingbyte), @fadingbyte);
  ConManager.Connection[ConnectionID].LoadDatFilePart(fileid, $89, SizeOf(depthbyte), @depthbyte);
  ConManager.Connection[ConnectionID].LoadDatFilePart(fileid, $90, SizeOf(storebyte), @storebyte);

  OniImage_Old.LoadFromTXMP(ConnectionID, fileid);
  old_size := OniImage_Old.GetImageSize(True);
  OniImage_Old.DrawOnCanvas(image_txmppreview.Canvas, 1);

  check_fading.Checked := OniImage_Old.HasMipMaps;
//  check_transparency.Checked := (depthbyte and $04) > 0;
  check_transparency.Checked := storebyte in [0, 2, 7];

  group_bmpselect.Enabled := True;
end;


procedure TForm_TxmpReplace.Splitter1Moved(Sender: TObject);
begin
  inherited;
  image_txmppreview.Picture.Assign(nil);
  image_bmppreview.Picture.Assign(nil);
  if Length(OniImage_Old.Images) > 0 then
    OniImage_Old.DrawOnCanvas(image_txmppreview.Canvas, 1);
  if Length(OniImage_New.Images) > 0 then
    OniImage_New.DrawOnCanvas(image_bmppreview.Canvas, 1);
end;

procedure TForm_TxmpReplace.btn_loadClick(Sender: TObject);
var
  mem:   TMemoryStream;
begin
  if opend.Execute then
  begin
    OniImage_New.LoadFromFile(opend.FileName);
    OniImage_New.DrawOnCanvas(image_bmppreview.Canvas, 1);
    group_options.Enabled := True;
  end;
end;




procedure TForm_TxmpReplace.btn_replaceClick(Sender: TObject);
var
  newsize: Integer;
  old_rawaddr, new_rawaddr: Integer;
  oldfading: Byte;
  datbyte: Word;
  mem: TMemoryStream;
  new_storetype: Byte;
  formatinfo: TImageFormatInfo;
begin
  if filelist.ItemIndex >= 0 then
  begin
    ConManager.Connection[ConnectionID].LoadDatFilePart(fileid, $88, 1, @oldfading);
    if not (ConManager.Connection[ConnectionID].DataOS = DOS_WIN) then
      ConManager.Connection[ConnectionID].LoadDatFilePart(fileid, $A0, 4, @old_rawaddr)
    else
      ConManager.Connection[ConnectionID].LoadDatFilePart(fileid, $9C, 4, @old_rawaddr);

    if (OniImage_Old.Width[1] <> OniImage_New.Width[1]) or
      (OniImage_Old.Height[1] <> OniImage_New.Height[1]) then
    begin
      if MessageBox(Self.Handle,
            PChar(
              'Current image and new image have different size' + CrLf +
              '(Current: ' + IntToStr(OniImage_Old.Width[1]) + 'x' +
              IntToStr(OniImage_Old.Height[1]) + ' - New: ' +
              IntToStr(OniImage_New.Width[1]) + 'x' +
              IntToStr(OniImage_New.Height[1]) +
              ')' + CrLf + 'Replace anyway?'),
            PChar(filelist.Items.Strings[filelist.ItemIndex]), MB_YESNO) = idNo then
        Exit;
    end;

    mem := TMemoryStream.Create;

    case OniImage_New.Format of
      ifX1R5G5B5: new_storetype := 1;
      ifA1R5G5B5: new_storetype := 2;
      ifA4R4G4B4: new_storetype := 0;
      ifA8R8G8B8:
        begin
          new_storetype := 8;
          OniImage_New.Format := ifX8R8G8B8;
        end;
      ifX8R8G8B8: new_storetype := 8;
      ifDXT1: new_storetype := 9;
    else
      if OniImage_New.FormatInfo.HasAlphaChannel then
        ShowMessage('Loaded image has an alpha-channel.' + #13#10 +
                    'Because the format is neither ARGB1555' +#13#10 +
                    'nor ARGB4444 it can not be imported without conversion.' + #13#10 +
                    'It is converted to RGB888, so alpha gets dropped.' + #13#10 +
                    'If you need alpha you have to save your image in' + #13#10 +
                    'one of the previously named formats.');  
      OniImage_New.Format := ifX8R8G8B8;
      new_storetype := 8;
    end;

    OniImage_New.SaveDataToStream(check_fading.Checked, TStream(mem));

    newsize := mem.Size;
    mem.Seek(0, soFromBeginning);

    if (newsize > old_size) and (ConManager.Connection[ConnectionID].Backend = DB_ONI) then
      new_rawaddr := ConManager.Connection[ConnectionID].AppendRawFile(
        not (ConManager.Connection[ConnectionID].DataOS = DOS_WIN), mem)
    else
    begin
      new_rawaddr := old_rawaddr;
      ConManager.Connection[ConnectionID].UpdateRawFile(fileid, $9C, mem);
    end;

    if check_fading.Checked then
      oldfading := oldfading or $01
    else
      oldfading := oldfading and (not Byte($01));
    ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $88, 1, @datbyte);
    datbyte := $10;
//    if check_transparency.Checked then
//      datbyte := datbyte or $04;
    ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $89, 1, @datbyte);
    datbyte := OniImage_New.Width[1];
    ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $8C, 2, @datbyte);
    datbyte := OniImage_New.Height[1];
    ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $8E, 2, @datbyte);
    ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $90, 1, @new_storetype);
    if not (ConManager.Connection[ConnectionID].DataOS = DOS_WIN) then
      ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $A0, 4, @new_rawaddr)
    else
      ConManager.Connection[ConnectionID].UpdateDatFilePart(fileid, $9C, 4, @new_rawaddr);

    ShowMessage('TXMP-image replaced');
    Self.listClick(Self);
  end;
end;




procedure TForm_TxmpReplace.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  OniImage_Old.Free;
  OniImage_New.Free;
  inherited;
end;




procedure TForm_TxmpReplace.FormCreate(Sender: TObject);
begin
  inherited;
  OniImage_Old := TOniImage.Create;
  OniImage_New := TOniImage.Create;
  Self.AllowedExts := 'TXMP';
  Self.OnNewFileSelected := SelectFile;
  opend.Filter := saved.Filter;
end;




procedure TForm_TxmpReplace.btn_saveClick(Sender: TObject);
begin
  if saved.Execute then
    OniImage_Old.WriteToFile(saved.FileName);
end;

begin
  AddToolListEntry('txmpreplace', 'TXMP Replacer', 'TXMP');
end.