unit _FileTypes;

interface

uses
  TypeDefs, _DataTypes;


type
  TFile = class
    private
      FConnectionID: Integer;
      FFileID: Integer;

      FDatLinks: TDatLinkList;
      FDataFields: TDataFields;
      FRawParts: TRawDataList;

      function GetDatLinkByOffset(Offset: Integer): TDatLink;
      function GetDatLinkByIndex(ID: Integer): TDatLink;
      function GetFieldByOffset(Offset: Integer): TDataField;
      function GetFieldByIndex(ID: Integer): TDataField;
      function GetRawPartByOffset(Offset: Integer): TRawDataInfo;
      function GetRawPartByIndex(ID: Integer): TRawDataInfo;
    public
      constructor Create(ConnectionID, FileID: Integer);
      
      property LinkByOffset[Offset: Integer]: TDatLink read GetDatLinkByOffset;
      property LinkByIndex[ID: Integer]: TDatLink read GetDatLinkByIndex;

      property FieldByOffset[Offset: Integer]: TDataField read GetFieldByOffset;
      property FieldByIndex[ID: Integer]: TDataField read GetFieldByIndex;

      property RawPartByOffset[Offset: Integer]: TRawDataInfo read GetRawPartByOffset;
      property RawPartByIndex[ID: Integer]: TRawDataInfo read GetRawPartByIndex;
  end;


implementation

uses
  DatLinks, RawList;

{ TFileType }

constructor TFile.Create(ConnectionID, FileID: Integer);
begin
  FConnectionID := ConnectionID;
  FFileID := FileID;

  FDatLinks := DatLinksManager.GetDatLinks(ConnectionID, FileID);
  FRawParts := RawLists.GetRawList(ConnectionID, FileID);
end;


function TFile.GetDatLinkByIndex(ID: Integer): TDatLink;
begin
  if ID < Length(FDatLinks) then
    Result := FDatLinks[ID]
  else
    with Result do
    begin
      SrcOffset := -1;
      DestID := -1;
      PosDestExts := '';
    end;
end;

function TFile.GetDatLinkByOffset(Offset: Integer): TDatLink;
var
  i: Integer;
begin
  Result.SrcOffset := -1;
  Result.DestID := -1;
  Result.PosDestExts := '';
  
  if Length(FDatLinks) > 0 then
  begin
    for i := 0 to High(FDatLinks) do
      if FDatLinks[i].SrcOffset = Offset then
        break;
    if i < Length(FDatLinks) then
      Result := FDatLinks[i];
  end;
end;


function TFile.GetFieldByIndex(ID: Integer): TDataField;
begin
  if ID < Length(FDataFields) then
    Result := FDataFields[ID]
  else
    Result := nil;
end;

function TFile.GetFieldByOffset(Offset: Integer): TDataField;
var
  i: Integer;
begin
  Result := nil;

  if Length(FDataFields) > 0 then
  begin
    for i := 0 to High(FDataFields) do
      if FDataFields[i].Offset = Offset then
        break;
    if i < Length(FDataFields) then
      Result := FDataFields[i];
  end;
end;


function TFile.GetRawPartByIndex(ID: Integer): TRawDataInfo;
begin
  if ID < Length(FRawParts) then
    Result := FRawParts[ID]
  else
    with Result do
    begin
      SrcID := -1;
      SrcOffset := -1;
      RawAddr := -1;
      RawSize := -1;
    end;
end;

function TFile.GetRawPartByOffset(Offset: Integer): TRawDataInfo;
var
  i: Integer;
begin
  with Result do
  begin
    SrcID := -1;
    SrcOffset := -1;
    RawAddr := -1;
    RawSize := -1;
  end;

  if Length(FRawParts) > 0 then
  begin
    for i := 0 to High(FRawParts) do
      if FRawParts[i].SrcOffset = Offset then
        break;
    if i < Length(FRawParts) then
      Result := FRawParts[i];
  end;
end;

end.
