unit _FileTypes;

interface

uses
  TypeDefs, _DataTypes, Classes;


type
  TFile = class
    protected
      FConnectionID: Integer;
      FFileID: Integer;
      FFile: TMemoryStream;

      FDatLinks: TDatLinkList;
      FDataFields: TBlock;
      FRawParts: TRawDataList;

      procedure InitDatLinks; virtual; abstract;
      procedure InitDataFields; virtual; abstract;
      procedure InitRawList; virtual; abstract;

      function GetDatLinkByOffset(Offset: Integer): TDatLink;
      function GetDatLinkByIndex(ID: Integer): TDatLink;
      function GetFieldByOffset(Offset: Integer): TDataField;
      function GetFieldByIndex(ID: Integer): TDataField;
      function GetRawPartByOffset(Offset: Integer): TRawDataInfo;
      function GetRawPartByIndex(ID: Integer): TRawDataInfo;
    public
      constructor Create(ConnectionID, FileID: Integer); virtual;
      procedure Free;

      property FileStream: TMemoryStream read FFile;
      property FileID: Integer read FFileID;
      property ConnectionID: Integer read FConnectionID;

      property LinkByOffset[Offset: Integer]: TDatLink read GetDatLinkByOffset;
      property LinkByIndex[ID: Integer]: TDatLink read GetDatLinkByIndex;

      property FieldByOffset[Offset: Integer]: TDataField read GetFieldByOffset;
      property FieldByIndex[ID: Integer]: TDataField read GetFieldByIndex;

      property RawPartByOffset[Offset: Integer]: TRawDataInfo read GetRawPartByOffset;
      property RawPartByIndex[ID: Integer]: TRawDataInfo read GetRawPartByIndex;
  end;


implementation

uses
  DatLinks, RawList, ConnectionManager, Dialogs;

{ TFileType }

constructor TFile.Create(ConnectionID, FileID: Integer);
var
  i: Integer;
begin
  FConnectionID := ConnectionID;
  FFileID := FileID;
  FFile := nil;

  FFile := TMemoryStream.Create;
  ConManager.Connection[ConnectionID].LoadDatFile(FileID, TStream(FFile));

  InitDatLinks();
  InitDataFields();
  InitRawList();

  if FDataFields.FieldCount > 0 then
  begin
    for i := 0 to FDataFields.FieldCount - 1 do
    begin
      ShowMessage(FDataFields.FieldByIndex[i].ValueAsString);
    end;
  end;

  FFile.Free;
  FFile := nil;

//  FDatLinks := DatLinksManager.GetDatLinks(ConnectionID, FileID);
//  FRawParts := RawLists.GetRawList(ConnectionID, FileID);
end;


procedure TFile.Free;
begin
  FDataFields.Free;
end;

function TFile.GetDatLinkByIndex(ID: Integer): TDatLink;
begin
  if ID < Length(FDatLinks) then
    Result := FDatLinks[ID]
  else
    with Result do
    begin
      SrcOffset := -1;
      DestID := -1;
      PosDestExts := '';
    end;
end;

function TFile.GetDatLinkByOffset(Offset: Integer): TDatLink;
var
  i: Integer;
begin
  Result.SrcOffset := -1;
  Result.DestID := -1;
  Result.PosDestExts := '';
  
  if Length(FDatLinks) > 0 then
  begin
    for i := 0 to High(FDatLinks) do
      if FDatLinks[i].SrcOffset = Offset then
        break;
    if i < Length(FDatLinks) then
      Result := FDatLinks[i];
  end;
end;


function TFile.GetFieldByIndex(ID: Integer): TDataField;
begin
  Result := FDataFields.FieldByIndex[ID];
end;

function TFile.GetFieldByOffset(Offset: Integer): TDataField;
var
  i: Integer;
begin
  Result := FDataFields.FieldByOffset[Offset];
end;


function TFile.GetRawPartByIndex(ID: Integer): TRawDataInfo;
begin
  if ID < Length(FRawParts) then
    Result := FRawParts[ID]
  else
    with Result do
    begin
      SrcID := -1;
      SrcOffset := -1;
      RawAddr := -1;
      RawSize := -1;
    end;
end;

function TFile.GetRawPartByOffset(Offset: Integer): TRawDataInfo;
var
  i: Integer;
begin
  with Result do
  begin
    SrcID := -1;
    SrcOffset := -1;
    RawAddr := -1;
    RawSize := -1;
  end;

  if Length(FRawParts) > 0 then
  begin
    for i := 0 to High(FRawParts) do
      if FRawParts[i].SrcOffset = Offset then
        break;
    if i < Length(FRawParts) then
      Result := FRawParts[i];
  end;
end;

end.
