unit _FileManager;
interface

uses _FileTypes, TXMP;

type
  TFileType = class of TFile;
  TFileDesc = record
    ext: String;
    ftype: TFileType;
  end;

const
  FileDescs: array[0..0] of TFileDesc = (
    (ext: 'TXMP'; ftype: TFile_TXMP)
  );

type
  TFileManager = class
    protected
      FFiles: array of TFile;
      FConnectionID: Integer;
      function GetFileCount: Integer;
      function GetFileById(Id: Integer): TFile;
    public
      constructor Create(ConnectionID: Integer);

      property FileCount: Integer read GetFileCount;
      property FileById[Id: Integer]: TFile read GetFileById;
  end;

implementation

uses
  Classes, ConnectionManager, Access_OniArchive, TypeDefs, Dialogs, SysUtils, StrUtils;

{ TFileManager }

constructor TFileManager.Create(ConnectionID: Integer);
var
  files: TStrings;
  i: Integer;
  typei: Integer;
  fid: Integer;
begin
  FConnectionID := ConnectionID;
  if ConManager.Connection[ConnectionID] is TAccess_OniArchive then
    TAccess_OniArchive(ConManager.Connection[ConnectionID]).UnloadWhenUnused := False;
  files := TStringList.Create;
  files := ConManager.Connection[ConnectionID].GetFilesList('', '', False, ST_IDAsc);
  if files.Count > 0 then
  begin
    for i := 0 to files.Count - 1 do
    begin
      for typei := 0 to High(FileDescs) do
      begin
        if Pos('.' + FileDescs[typei].ext, files.Strings[i]) = Length(files.Strings[i]) - 4 then
        begin
          SetLength(FFiles, Length(FFiles) + 1);
          fid := StrToInt(MidStr(files.Strings[i], 1, 5));
          FFiles[High(FFiles)] := TFileType(FileDescs[typei].ftype).Create(FConnectionID, fid);
        end;
      end;
    end;
  end;
  files.Free;
  if ConManager.Connection[ConnectionID] is TAccess_OniArchive then
    TAccess_OniArchive(ConManager.Connection[ConnectionID]).UnloadWhenUnused := True;
end;

function TFileManager.GetFileById(Id: Integer): TFile;
begin
  Result := FFiles[Id];
end;

function TFileManager.GetFileCount: Integer;
begin
  Result := Length(FFiles);
end;

end.
