UNIT Unit7_txmpreplace;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, StrUtils, Unit2_functions, Unit3_data;

TYPE
  TForm7 = Class(TForm)
    panel_12: TPanel;
    group_txmpselect: TGroupBox;
    splitter_txmp: TSplitter;
    image_txmppreview: TImage;
    list_txmp: TListBox;
    Splitter1: TSplitter;
    group_bmpselect: TGroupBox;
    panel_main: TPanel;
    btn_replace: TButton;
    panel_load: TPanel;
    btn_load: TButton;
    image_bmppreview: TImage;
    opend: TOpenDialog;
    PROCEDURE btn_replaceClick(Sender: TObject);
    PROCEDURE btn_loadClick(Sender: TObject);
    PROCEDURE list_txmpClick(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE RecreateTXMPlist;
  PRIVATE
  PUBLIC
  END;

VAR
  Form7: TForm7;

IMPLEMENTATION
USES Unit1_main, Unit6_imgfuncs;
{$R *.dfm}
VAR
  actual_bmpdata:Tdata;

PROCEDURE TForm7.RecreateTXMPlist;
  VAR
    i:LongWord;
  BEGIN
    Form7.list_txmp.Items.Clear;
    FOR i:=0 TO dat_header.Files-1 DO BEGIN
      IF (dat_files[i].Extension='TXMP') AND ((dat_files[i].FileType AND $02)=0) THEN
        Form7.list_txmp.Items.Add(dat_files[i].FileName);
    END;
    Form7.group_bmpselect.Enabled:=False;
  END;

PROCEDURE TForm7.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    CanClose:=False;
    Form7.Visible:=False;
  END;

PROCEDURE TForm7.FormResize(Sender: TObject);
  BEGIN
    IF Form7.Width>=400 THEN BEGIN
    END ELSE Form7.Width:=400;
    IF Form7.Height>=350 THEN BEGIN
    END ELSE Form7.Height:=350;
  END;

PROCEDURE TForm7.list_txmpClick(Sender: TObject);
  VAR
    id:LongWord;
    data:Tdata;
    img:TImgPackage;
    mem:TMemoryStream;
  BEGIN
    id:=StrToInt(MidStr(list_txmp.Items.Strings[list_txmp.ItemIndex],1,5));

    img:=LoadImgData(id);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    mem:=TMemoryStream.Create;
    mem.Write(data[0],Length(data));
    mem.Seek(0,soFromBeginning);
    Form7.image_txmppreview.Picture.Bitmap.LoadFromStream(mem);
    mem.Free;

    Form7.group_bmpselect.Enabled:=True;
  END;

PROCEDURE TForm7.btn_loadClick(Sender: TObject);
  VAR
    bmpfile:TFileStream;
    mem:TMemoryStream;
  BEGIN
    IF opend.Execute THEN BEGIN
      bmpfile:=TFileStream.Create(opend.FileName, fmOpenRead);
      SetLength(actual_bmpdata,bmpfile.Size);
      bmpfile.Read(actual_bmpdata[0],bmpfile.Size);
      bmpfile.Free;

      mem:=TMemoryStream.Create;
      mem.Write(actual_bmpdata[0],Length(actual_bmpdata));
      mem.Seek(0,soFromBeginning);
      Form7.image_bmppreview.Picture.Bitmap.LoadFromStream(mem);
      mem.Free;

      Form7.panel_main.Enabled:=True;
    END;
  END;

PROCEDURE TForm7.btn_replaceClick(Sender: TObject);
  VAR
    id:LongWord;
    imgpkg:TImgPackage;
    rawfile:TFileStream;
    datfile:TFileStream;
    dataddr:LongWord;
    new_rawaddr:LongWord;
    oldwidth,oldheight:Word;
    datword:Word;
  BEGIN
    IF Form7.list_txmp.ItemIndex>=0 THEN BEGIN
      imgpkg:=BmpToImgdata(actual_bmpdata);
      rawfile:=TFileStream.Create(raw_filename,fmOpenReadWrite);
      datfile:=TFileStream.Create(dat_filename,fmOpenReadWrite);

      id:=StrToInt(MidStr(list_txmp.Items.Strings[list_txmp.ItemIndex],1,5));
      dataddr:=dat_files[id].dataddr;
      datfile.Seek(dataddr+$8C,soFromBeginning);
      datfile.Read(oldwidth,2);
      datfile.Seek(dataddr+$8E,soFromBeginning);
      datfile.Read(oldheight,2);
      IF (oldwidth<>imgpkg.imgx) OR (oldheight<>imgpkg.imgy) THEN BEGIN
        IF MessageBox(Form7.Handle,
                    PChar('Current image and new image have different size'+CrLf+
                            '(Current: '+IntToStr(oldwidth)+'x'+IntToStr(oldheight)+
                            ' - New: '+IntToStr(imgpkg.imgx)+'x'+IntToStr(imgpkg.imgy)+')'+CrLf+
                            'Replace anyways?'),
                    PChar('Really replace?'),
                    MB_YESNO)=IDNO THEN Exit;
      END;
      new_rawaddr:=rawfile.Size;

      datword:=$1000;
      datfile.Seek(dataddr+$88,soFromBeginning);
      datfile.Write(datword,2);
      datfile.Seek(dataddr+$8C,soFromBeginning);
      datfile.Write(imgpkg.imgx,2);
      datfile.Seek(dataddr+$8E,soFromBeginning);
      datfile.Write(imgpkg.imgy,2);
      datword:=$0001;
      datfile.Seek(dataddr+$90,soFromBeginning);
      datfile.Write(datword,2);
      datfile.Seek(dataddr+$9C,soFromBeginning);
      datfile.Write(new_rawaddr,4);
      datfile.Free;

      rawfile.Seek(new_rawaddr,soFromBeginning);
      rawfile.Write(imgpkg.imgdata[0],Length(imgpkg.imgdata)); 
      rawfile.Free;
    END;
  END;

END.
